/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.quic.quiche.jna;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.eclipse.jetty.quic.quiche.Quiche;
import org.eclipse.jetty.quic.quiche.QuicheBinding;
import org.eclipse.jetty.quic.quiche.QuicheConfig;
import org.eclipse.jetty.quic.quiche.jna.JnaQuicheConnection;
import org.eclipse.jetty.quic.quiche.jna.LibQuiche;
import org.eclipse.jetty.util.TypeUtil;

public class JnaQuicheBinding
implements QuicheBinding {
    private Throwable failure;

    public Throwable initialize() {
        try {
            LibQuiche.initialize();
            this.failure = null;
        }
        catch (ExceptionInInitializerError e) {
            Throwable cause = e.getCause();
            this.failure = cause != null ? cause : e;
        }
        catch (Throwable x) {
            this.failure = x;
        }
        return this.failure;
    }

    public int priority() {
        return 200;
    }

    public byte[] fromPacket(ByteBuffer packet) {
        return JnaQuicheConnection.fromPacket(packet);
    }

    public Quiche connect(QuicheConfig quicheConfig, InetSocketAddress local, InetSocketAddress peer, int connectionIdLength) throws IOException {
        return JnaQuicheConnection.connect(quicheConfig, local, peer, connectionIdLength);
    }

    public boolean negotiate(Quiche.TokenMinter tokenMinter, ByteBuffer packetRead, ByteBuffer packetToSend) throws IOException {
        return JnaQuicheConnection.negotiate(tokenMinter, packetRead, packetToSend);
    }

    public Quiche tryAccept(QuicheConfig quicheConfig, Quiche.TokenValidator tokenValidator, ByteBuffer packetRead, SocketAddress local, SocketAddress peer) throws IOException {
        return JnaQuicheConnection.tryAccept(quicheConfig, tokenValidator, packetRead, local, peer);
    }

    public String toString() {
        return TypeUtil.toShortName(this.getClass()) + "{p=" + this.priority() + " f=" + String.valueOf(this.failure) + "}";
    }
}

