/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.annotations;

import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.ee9.annotations.AbstractDiscoverableAnnotationHandler;
import org.eclipse.jetty.ee9.annotations.WebListenerAnnotation;
import org.eclipse.jetty.ee9.webapp.WebAppContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebListenerAnnotationHandler
extends AbstractDiscoverableAnnotationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(WebListenerAnnotationHandler.class);

    public WebListenerAnnotationHandler(WebAppContext context) {
        super(context);
    }

    public void handle(AnnotationParser.ClassInfo info, String annotationName) {
        if (annotationName == null || !"jakarta.servlet.annotation.WebListener".equals(annotationName)) {
            return;
        }
        WebListenerAnnotation wlAnnotation = new WebListenerAnnotation(this._context, info.getClassName(), info.getContainingResource());
        this.addAnnotation(wlAnnotation);
    }

    public void handle(AnnotationParser.FieldInfo info, String annotationName) {
        if (annotationName == null || !"jakarta.servlet.annotation.WebListener".equals(annotationName)) {
            return;
        }
        LOG.warn("@WebListener is not applicable to fields: {}.{}", (Object)info.getClassInfo().getClassName(), (Object)info.getFieldName());
    }

    public void handle(AnnotationParser.MethodInfo info, String annotationName) {
        if (annotationName == null || !"jakarta.servlet.annotation.WebListener".equals(annotationName)) {
            return;
        }
        LOG.warn("@WebListener is not applicable to methods: {}.{} {}", new Object[]{info.getClassInfo().getClassName(), info.getMethodName(), info.getSignature()});
    }
}

