/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee9.websocket.jakarta.common.decoders;

import jakarta.websocket.DecodeException;
import jakarta.websocket.Decoder;
import org.eclipse.jetty.ee9.websocket.jakarta.common.decoders.AbstractDecoder;

public class ByteDecoder
extends AbstractDecoder
implements Decoder.Text<Byte> {
    public static final ByteDecoder INSTANCE = new ByteDecoder();

    public Byte decode(String s) throws DecodeException {
        try {
            return Byte.parseByte(s);
        }
        catch (NumberFormatException e) {
            throw new DecodeException(s, "Unable to parse Byte", (Throwable)e);
        }
    }

    public boolean willDecode(String s) {
        if (s == null) {
            return false;
        }
        try {
            Byte.parseByte(s);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

