/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security.siwe.internal;

import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.Arrays;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.jcajce.provider.digest.Keccak;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.eclipse.jetty.security.siwe.EthereumAuthenticator;
import org.eclipse.jetty.util.StringUtil;

public class EthereumUtil {
    public static final String PREFIX = "\u0019Ethereum Signed Message:\n";
    private static final String NONCE_CHARACTERS = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static final SecureRandom RANDOM = new SecureRandom();
    private static final int ADDRESS_LENGTH_BYTES = 20;
    private static final X9ECParameters SEC_P256K1_PARAMS = CustomNamedCurves.getByName((String)"secp256k1");
    private static final ECDomainParameters DOMAIN_PARAMS = new ECDomainParameters(SEC_P256K1_PARAMS.getCurve(), SEC_P256K1_PARAMS.getG(), SEC_P256K1_PARAMS.getN(), SEC_P256K1_PARAMS.getH());
    private static final BigInteger PRIME = SEC_P256K1_PARAMS.getCurve().getField().getCharacteristic();
    private static final X9IntegerConverter INT_CONVERTER = new X9IntegerConverter();
    private static final Charset CHARSET = StandardCharsets.UTF_8;

    private EthereumUtil() {
    }

    public static String recoverAddress(EthereumAuthenticator.SignedMessage signedMessage) {
        BigInteger s;
        BigInteger r;
        byte[] signatureBytes;
        byte v;
        int messageLength;
        String prefixedMessage;
        byte[] messageHash;
        ECPoint qPoint;
        String siweMessage = signedMessage.message();
        String signatureHex = signedMessage.signature();
        if (StringUtil.asciiStartsWithIgnoreCase((String)signatureHex, (String)"0x")) {
            signatureHex = signatureHex.substring(2);
        }
        if ((qPoint = EthereumUtil.ecRecover(messageHash = EthereumUtil.keccak256((prefixedMessage = PREFIX + (messageLength = siweMessage.getBytes(CHARSET).length) + siweMessage).getBytes(CHARSET)), v = (byte)((signatureBytes = StringUtil.fromHexString((String)signatureHex))[64] < 27 ? signatureBytes[64] : signatureBytes[64] - 27), r = new BigInteger(1, Arrays.copyOfRange(signatureBytes, 0, 32)), s = new BigInteger(1, Arrays.copyOfRange(signatureBytes, 32, 64)))) == null) {
            return null;
        }
        return EthereumUtil.toAddress(qPoint);
    }

    public static ECPoint ecRecover(byte[] hash, int v, BigInteger r, BigInteger s) {
        if (v < 0 || v >= 4) {
            throw new IllegalArgumentException("Invalid v value: " + v);
        }
        BigInteger n = DOMAIN_PARAMS.getN();
        if (r.compareTo(BigInteger.ONE) < 0 || r.compareTo(n.subtract(BigInteger.ONE)) > 0) {
            return null;
        }
        if (s.compareTo(BigInteger.ONE) < 0 || s.compareTo(n.subtract(BigInteger.ONE)) > 0) {
            return null;
        }
        BigInteger x = r.add(BigInteger.valueOf(v / 2).multiply(n));
        if (x.compareTo(PRIME) >= 0) {
            return null;
        }
        ECPoint rPoint = EthereumUtil.decodePoint(x, v);
        if (!rPoint.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger e = new BigInteger(1, hash);
        BigInteger rInv = r.modInverse(n);
        BigInteger u1 = e.negate().multiply(rInv).mod(n);
        BigInteger u2 = s.multiply(rInv).mod(n);
        return ECAlgorithms.sumOfTwoMultiplies((ECPoint)DOMAIN_PARAMS.getG(), (BigInteger)u1, (ECPoint)rPoint, (BigInteger)u2);
    }

    public static String toAddress(ECPoint point) {
        byte[] qBytes = point.getEncoded(false);
        byte[] qHash = EthereumUtil.keccak256(qBytes, 1, qBytes.length - 1);
        byte[] address = new byte[20];
        System.arraycopy(qHash, qHash.length - 20, address, 0, 20);
        return "0x" + StringUtil.toHexString((byte[])address);
    }

    public static ECPoint decodePoint(BigInteger p, int v) {
        byte[] encodedPoint = INT_CONVERTER.integerToBytes(p, 1 + INT_CONVERTER.getByteLength(DOMAIN_PARAMS.getCurve()));
        encodedPoint[0] = (byte)(v % 2 == 0 ? 2 : 3);
        return DOMAIN_PARAMS.getCurve().decodePoint(encodedPoint);
    }

    public static byte[] keccak256(byte[] bytes) {
        Keccak.Digest256 digest256 = new Keccak.Digest256();
        return digest256.digest(bytes);
    }

    public static byte[] keccak256(byte[] buf, int offset, int len) {
        Keccak.Digest256 digest256 = new Keccak.Digest256();
        digest256.update(buf, offset, len);
        return digest256.digest();
    }

    public static String createNonce() {
        StringBuilder builder = new StringBuilder(8);
        for (int i = 0; i < 8; ++i) {
            int character = RANDOM.nextInt(NONCE_CHARACTERS.length());
            builder.append(NONCE_CHARACTERS.charAt(character));
        }
        return builder.toString();
    }
}

