/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class InputStreamResponseListener
extends Response.Listener.Empty {
    private static final Logger LOG = Log.getLogger(InputStreamResponseListener.class);
    private static final byte[] EOF = new byte[0];
    private static final byte[] CLOSED = new byte[0];
    private static final byte[] FAILURE = new byte[0];
    private final BlockingQueue<byte[]> queue = new LinkedBlockingQueue<byte[]>();
    private final AtomicLong length = new AtomicLong();
    private final CountDownLatch responseLatch = new CountDownLatch(1);
    private final CountDownLatch resultLatch = new CountDownLatch(1);
    private final AtomicReference<InputStream> stream = new AtomicReference();
    private final long maxBufferSize;
    private Response response;
    private Result result;
    private volatile Throwable failure;
    private volatile boolean closed;

    public InputStreamResponseListener() {
        this(16384L);
    }

    public InputStreamResponseListener(long maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
    }

    @Override
    public void onHeaders(Response response) {
        this.response = response;
        this.responseLatch.countDown();
    }

    @Override
    public void onContent(Response response, ByteBuffer content) {
        if (this.closed) {
            return;
        }
        int remaining = content.remaining();
        byte[] bytes = new byte[remaining];
        content.get(bytes);
        LOG.debug("Queuing {}/{} bytes", new Object[]{bytes, bytes.length});
        this.queue.offer(bytes);
        long newLength = this.length.addAndGet(remaining);
        while (newLength >= this.maxBufferSize) {
            LOG.debug("Queued bytes limit {}/{} exceeded, waiting", new Object[]{newLength, this.maxBufferSize});
            if (!this.await()) break;
            newLength = this.length.get();
            LOG.debug("Queued bytes limit {}/{} exceeded, woken up", new Object[]{newLength, this.maxBufferSize});
        }
    }

    @Override
    public void onComplete(Result result) {
        this.result = result;
        if (result.isSucceeded()) {
            LOG.debug("Queuing end of content {}{}", new Object[]{EOF, ""});
            this.queue.offer(EOF);
        } else {
            LOG.debug("Queuing failure {} {}", new Object[]{FAILURE, this.failure});
            this.queue.offer(FAILURE);
            this.failure = result.getFailure();
            this.responseLatch.countDown();
        }
        this.resultLatch.countDown();
        this.signal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean await() {
        try {
            InputStreamResponseListener inputStreamResponseListener = this;
            synchronized (inputStreamResponseListener) {
                while (this.length.get() >= this.maxBufferSize && this.failure == null && !this.closed) {
                    this.wait();
                }
                return this.failure == null && !this.closed;
            }
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void signal() {
        InputStreamResponseListener inputStreamResponseListener = this;
        synchronized (inputStreamResponseListener) {
            this.notifyAll();
        }
    }

    public Response get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        boolean expired;
        boolean bl = expired = !this.responseLatch.await(timeout, unit);
        if (expired) {
            throw new TimeoutException();
        }
        if (this.failure != null) {
            throw new ExecutionException(this.failure);
        }
        return this.response;
    }

    public Result await(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        boolean expired;
        boolean bl = expired = !this.resultLatch.await(timeout, unit);
        if (expired) {
            throw new TimeoutException();
        }
        return this.result;
    }

    public InputStream getInputStream() {
        Input result = new Input();
        if (this.stream.compareAndSet(null, result)) {
            return result;
        }
        return IO.getClosedStream();
    }

    private class Input
    extends InputStream {
        private byte[] bytes;
        private int index;

        private Input() {
        }

        @Override
        public int read() throws IOException {
            while (true) {
                if (this.bytes == EOF) {
                    this.index = -1;
                    return -1;
                }
                if (this.bytes == FAILURE) {
                    throw this.failure();
                }
                if (this.bytes == CLOSED) {
                    if (this.index < 0) {
                        return -1;
                    }
                    throw new AsynchronousCloseException();
                }
                if (this.bytes != null) {
                    int result = this.bytes[this.index] & 0xFF;
                    if (++this.index == this.bytes.length) {
                        InputStreamResponseListener.this.length.addAndGet(-this.index);
                        this.bytes = null;
                        this.index = 0;
                        InputStreamResponseListener.this.signal();
                    }
                    return result;
                }
                this.bytes = this.take();
                LOG.debug("Dequeued {}/{} bytes", new Object[]{this.bytes, this.bytes.length});
            }
        }

        private IOException failure() {
            if (InputStreamResponseListener.this.failure instanceof IOException) {
                return (IOException)InputStreamResponseListener.this.failure;
            }
            return new IOException(InputStreamResponseListener.this.failure);
        }

        private byte[] take() throws IOException {
            try {
                return (byte[])InputStreamResponseListener.this.queue.take();
            }
            catch (InterruptedException x) {
                throw new InterruptedIOException();
            }
        }

        @Override
        public void close() throws IOException {
            LOG.debug("Queuing close {}{}", new Object[]{CLOSED, ""});
            InputStreamResponseListener.this.queue.offer(CLOSED);
            InputStreamResponseListener.this.closed = true;
            InputStreamResponseListener.this.signal();
            super.close();
        }
    }
}

