/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.io.InputStream;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.io.RetainableByteBufferPool;
import org.eclipse.jetty.io.content.InputStreamContentSource;

public class InputStreamRequestContent
extends InputStreamContentSource
implements Request.Content {
    private final String contentType;

    public InputStreamRequestContent(InputStream stream) {
        this(stream, 4096);
    }

    public InputStreamRequestContent(InputStream stream, int bufferSize) {
        this("application/octet-stream", stream, bufferSize);
    }

    public InputStreamRequestContent(String contentType, InputStream stream, int bufferSize) {
        this(contentType, stream);
        this.setBufferSize(bufferSize);
    }

    public InputStreamRequestContent(String contentType, InputStream stream) {
        this(contentType, stream, null);
    }

    public InputStreamRequestContent(String contentType, InputStream stream, RetainableByteBufferPool bufferPool) {
        super(stream, bufferPool);
        this.contentType = contentType;
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }
}

