/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client.util;

import java.nio.ByteBuffer;
import java.util.stream.Stream;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.io.content.AsyncContent;
import org.eclipse.jetty.util.Callback;

public class AsyncRequestContent
extends AsyncContent
implements Request.Content {
    private final String contentType;

    public AsyncRequestContent(ByteBuffer ... buffers) {
        this("application/octet-stream", buffers);
    }

    public AsyncRequestContent(String contentType, ByteBuffer ... buffers) {
        this.contentType = contentType;
        Stream.of(buffers).forEach(buffer -> this.write((ByteBuffer)buffer, Callback.NOOP));
    }

    @Override
    public String getContentType() {
        return this.contentType;
    }

    public void write(ByteBuffer buffer, Callback callback) {
        this.write(false, buffer, callback);
    }
}

