/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.ByteBufferContentSource;
import org.eclipse.jetty.util.AtomicBiInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseNotifier {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseNotifier.class);

    public void notifyBegin(List<Response.ResponseListener> listeners, Response response) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.BeginListener)) continue;
            this.notifyBegin((Response.BeginListener)listener, response);
        }
    }

    private void notifyBegin(Response.BeginListener listener, Response response) {
        try {
            listener.onBegin(response);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public boolean notifyHeader(List<Response.ResponseListener> listeners, Response response, HttpField field) {
        boolean result = true;
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.HeaderListener)) continue;
            result &= this.notifyHeader((Response.HeaderListener)listener, response, field);
        }
        return result;
    }

    private boolean notifyHeader(Response.HeaderListener listener, Response response, HttpField field) {
        try {
            return listener.onHeader(response, field);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
            return false;
        }
    }

    public void notifyHeaders(List<Response.ResponseListener> listeners, Response response) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.HeadersListener)) continue;
            this.notifyHeaders((Response.HeadersListener)listener, response);
        }
    }

    private void notifyHeaders(Response.HeadersListener listener, Response response) {
        try {
            listener.onHeaders(response);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void notifyContent(Response response, Content.Source contentSource, List<Response.ContentSourceListener> contentListeners) {
        int count = contentListeners.size();
        if (count == 0) {
            ResponseNotifier.consumeAll(contentSource);
        } else if (count == 1) {
            Response.ContentSourceListener listener = contentListeners.get(0);
            this.notifyContent(listener, response, contentSource);
        } else {
            ContentSourceDemultiplexer demultiplexer = new ContentSourceDemultiplexer(contentSource, contentListeners.size());
            for (int i = 0; i < contentListeners.size(); ++i) {
                Response.ContentSourceListener listener = contentListeners.get(i);
                this.notifyContent(listener, response, demultiplexer.contentSource(i));
            }
        }
    }

    private static void consumeAll(Content.Source contentSource) {
        Content.Chunk chunk = contentSource.read();
        if (chunk != null) {
            chunk.release();
        }
        if (chunk == null || !chunk.isLast()) {
            contentSource.demand(() -> ResponseNotifier.consumeAll(contentSource));
        }
    }

    private void notifyContent(Response.ContentSourceListener listener, Response response, Content.Source contentSource) {
        try {
            listener.onContentSource(response, contentSource);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void notifySuccess(List<Response.ResponseListener> listeners, Response response) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.SuccessListener)) continue;
            this.notifySuccess((Response.SuccessListener)listener, response);
        }
    }

    private void notifySuccess(Response.SuccessListener listener, Response response) {
        try {
            listener.onSuccess(response);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void notifyFailure(List<Response.ResponseListener> listeners, Response response, Throwable failure) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.FailureListener)) continue;
            this.notifyFailure((Response.FailureListener)listener, response, failure);
        }
    }

    private void notifyFailure(Response.FailureListener listener, Response response, Throwable failure) {
        try {
            listener.onFailure(response, failure);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void notifyComplete(List<Response.ResponseListener> listeners, Result result) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.CompleteListener)) continue;
            this.notifyComplete((Response.CompleteListener)listener, result);
        }
    }

    private void notifyComplete(Response.CompleteListener listener, Result result) {
        try {
            listener.onComplete(result);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public void forwardSuccess(List<Response.ResponseListener> listeners, Response response) {
        this.forwardEvents(listeners, response);
        this.notifySuccess(listeners, response);
    }

    public void forwardSuccessComplete(List<Response.ResponseListener> listeners, Request request, Response response) {
        this.forwardSuccess(listeners, response);
        this.notifyComplete(listeners, new Result(request, response));
    }

    public void forwardFailure(List<Response.ResponseListener> listeners, Response response, Throwable failure) {
        this.forwardEvents(listeners, response);
        this.notifyFailure(listeners, response, failure);
    }

    private void forwardEvents(List<Response.ResponseListener> listeners, Response response) {
        byte[] content;
        this.notifyBegin(listeners, response);
        Iterator iterator = response.getHeaders().iterator();
        while (iterator.hasNext()) {
            HttpField field = (HttpField)iterator.next();
            if (this.notifyHeader(listeners, response, field)) continue;
            iterator.remove();
        }
        this.notifyHeaders(listeners, response);
        if (response instanceof ContentResponse && (content = ((ContentResponse)response).getContent()) != null && content.length > 0) {
            List<Response.ContentSourceListener> contentListeners = listeners.stream().filter(Response.ContentSourceListener.class::isInstance).map(Response.ContentSourceListener.class::cast).toList();
            ByteBufferContentSource byteBufferContentSource = new ByteBufferContentSource(new ByteBuffer[]{ByteBuffer.wrap(content)});
            this.notifyContent(response, (Content.Source)byteBufferContentSource, contentListeners);
        }
    }

    public void forwardFailureComplete(List<Response.ResponseListener> listeners, Request request, Throwable requestFailure, Response response, Throwable responseFailure) {
        this.forwardFailure(listeners, response, responseFailure);
        this.notifyComplete(listeners, new Result(request, requestFailure, response, responseFailure));
    }

    private static class ContentSourceDemultiplexer {
        private static final Logger LOG = LoggerFactory.getLogger(ContentSourceDemultiplexer.class);
        private final Content.Source originalContentSource;
        private final ContentSource[] demultiplexerContentSources;
        private final AtomicBiInteger counters = new AtomicBiInteger();

        private ContentSourceDemultiplexer(Content.Source originalContentSource, int size) {
            if (size < 2) {
                throw new IllegalArgumentException("Demultiplexer can only be used with a size >= 2");
            }
            this.originalContentSource = originalContentSource;
            this.demultiplexerContentSources = new ContentSource[size];
            for (int i = 0; i < size; ++i) {
                this.demultiplexerContentSources[i] = new ContentSource(i);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using demultiplexer with a size of {}", (Object)size);
            }
        }

        public Content.Source contentSource(int index) {
            return this.demultiplexerContentSources[index];
        }

        private void onDemandCallback() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Original content source's demand calling back");
            }
            Content.Chunk chunk = this.originalContentSource.read();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Read from original content source {}", (Object)chunk);
            }
            for (ContentSource demultiplexerContentSource : this.demultiplexerContentSources) {
                demultiplexerContentSource.onChunk(chunk);
            }
        }

        private void registerFailure(Throwable failure) {
            block3: {
                int demands;
                block2: {
                    int failures;
                    long encoded;
                    do {
                        encoded = this.counters.get();
                        failures = AtomicBiInteger.getHi((long)encoded) + 1;
                        demands = AtomicBiInteger.getLo((long)encoded);
                        if (demands != this.demultiplexerContentSources.length - failures) continue;
                        demands = 0;
                    } while (!this.counters.compareAndSet(encoded, failures, demands));
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Registered failure; failures={} demands={}", (Object)failures, (Object)demands);
                    }
                    if (failures != this.demultiplexerContentSources.length) break block2;
                    this.originalContentSource.fail(failure);
                    break block3;
                }
                if (demands != 0) break block3;
                this.originalContentSource.demand(this::onDemandCallback);
            }
        }

        private void registerDemand() {
            block2: {
                int demands;
                int failures;
                long encoded;
                do {
                    encoded = this.counters.get();
                    failures = AtomicBiInteger.getHi((long)encoded);
                    demands = AtomicBiInteger.getLo((long)encoded) + 1;
                    if (demands != this.demultiplexerContentSources.length - failures) continue;
                    demands = 0;
                } while (!this.counters.compareAndSet(encoded, failures, demands));
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Registered demand; failures={} demands={}", (Object)failures, (Object)demands);
                }
                if (demands != 0) break block2;
                this.originalContentSource.demand(this::onDemandCallback);
            }
        }

        private class ContentSource
        implements Content.Source {
            private static final Content.Chunk ALREADY_READ_CHUNK = new Content.Chunk(){

                public ByteBuffer getByteBuffer() {
                    throw new UnsupportedOperationException();
                }

                public boolean isLast() {
                    throw new UnsupportedOperationException();
                }

                public void retain() {
                    throw new UnsupportedOperationException();
                }

                public boolean release() {
                    throw new UnsupportedOperationException();
                }

                public String toString() {
                    return "ALREADY_READ_CHUNK";
                }
            };
            private final int index;
            private final AtomicReference<Runnable> demandCallbackRef = new AtomicReference();
            private volatile Content.Chunk chunk;

            private ContentSource(int index) {
                this.index = index;
            }

            private void onChunk(Content.Chunk chunk) {
                Content.Chunk currentChunk = this.chunk;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Registering content in multiplexed content source #{} that contains {}", (Object)this.index, (Object)currentChunk);
                }
                if (currentChunk == null || currentChunk == ALREADY_READ_CHUNK) {
                    this.chunk = chunk.slice();
                } else if (!currentChunk.isLast()) {
                    throw new IllegalStateException("Cannot overwrite chunk");
                }
                this.onDemandCallback();
            }

            private void onDemandCallback() {
                Runnable callback = this.demandCallbackRef.getAndSet(null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content source #{} invoking demand callback {}", (Object)this.index, (Object)callback);
                }
                if (callback != null) {
                    try {
                        callback.run();
                    }
                    catch (Throwable x) {
                        this.fail(x);
                    }
                }
            }

            public Content.Chunk read() {
                if (this.chunk == ALREADY_READ_CHUNK) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Content source #{} already read current chunk", (Object)this.index);
                    }
                    return null;
                }
                Content.Chunk result = this.chunk;
                if (result != null && !result.isTerminal()) {
                    this.chunk = ALREADY_READ_CHUNK;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content source #{} reading current chunk {}", (Object)this.index, (Object)result);
                }
                return result;
            }

            public void demand(Runnable demandCallback) {
                if (!this.demandCallbackRef.compareAndSet(null, Objects.requireNonNull(demandCallback))) {
                    throw new IllegalStateException();
                }
                Content.Chunk currentChunk = this.chunk;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content source #{} demand while current chunk is {}", (Object)this.index, (Object)currentChunk);
                }
                if (currentChunk == null || currentChunk == ALREADY_READ_CHUNK) {
                    ContentSourceDemultiplexer.this.registerDemand();
                } else {
                    this.onDemandCallback();
                }
            }

            public void fail(Throwable failure) {
                Content.Chunk currentChunk = this.chunk;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Content source #{} fail while current chunk is {}", (Object)this.index, (Object)currentChunk);
                }
                if (currentChunk instanceof Content.Chunk.Error) {
                    return;
                }
                if (currentChunk != null) {
                    currentChunk.release();
                }
                this.chunk = Content.Chunk.from((Throwable)failure);
                this.onDemandCallback();
                ContentSourceDemultiplexer.this.registerFailure(failure);
            }
        }
    }
}

