/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.client.ContentDecoder;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.content.ContentSourceTransformer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HttpReceiver {
    private static final Logger LOG = LoggerFactory.getLogger(HttpReceiver.class);
    private final SerializedInvoker invoker = new SerializedInvoker();
    private final HttpChannel channel;
    private ResponseState responseState = ResponseState.IDLE;
    private NotifiableContentSource contentSource;
    private Throwable failure;

    protected HttpReceiver(HttpChannel channel) {
        this.channel = channel;
    }

    protected abstract Content.Chunk read(boolean var1);

    protected abstract void onInterim();

    protected abstract void failAndClose(Throwable var1);

    protected HttpChannel getHttpChannel() {
        return this.channel;
    }

    protected HttpExchange getHttpExchange() {
        return this.channel.getHttpExchange();
    }

    protected HttpDestination getHttpDestination() {
        return this.channel.getHttpDestination();
    }

    public boolean isFailed() {
        return this.responseState == ResponseState.FAILURE;
    }

    protected boolean hasContent() {
        return this.contentSource != null;
    }

    protected void responseBegin(HttpExchange exchange) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseBegin for {} on {}", (Object)exchange, (Object)this);
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseBegin for {} on {}", (Object)exchange, (Object)this);
            }
            if (exchange.isResponseComplete()) {
                return;
            }
            this.responseState = ResponseState.BEGIN;
            HttpConversation conversation = exchange.getConversation();
            HttpResponse response = exchange.getResponse();
            HttpDestination destination = this.getHttpDestination();
            HttpClient client = destination.getHttpClient();
            ProtocolHandler protocolHandler = client.findProtocolHandler(exchange.getRequest(), response);
            Response.Listener handlerListener = null;
            if (protocolHandler != null) {
                handlerListener = protocolHandler.getResponseListener();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Response {} found protocol handler {}", (Object)response, (Object)protocolHandler);
                }
            }
            exchange.getConversation().updateResponseListeners(handlerListener);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response begin {}", (Object)response);
            }
            ResponseNotifier notifier = destination.getResponseNotifier();
            notifier.notifyBegin(conversation.getResponseListeners(), (Response)response);
        });
    }

    protected void responseHeader(HttpExchange exchange, HttpField field) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseHeader for {} on {}", (Object)field, (Object)this);
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseHeader on {}", (Object)this);
            }
            if (exchange.isResponseComplete()) {
                return;
            }
            this.responseState = ResponseState.HEADER;
            HttpResponse response = exchange.getResponse();
            ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Notifying header {}", (Object)field);
            }
            boolean process = notifier.notifyHeader(exchange.getConversation().getResponseListeners(), (Response)response, field);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Header {} notified, {}processing needed", (Object)field, (Object)(process ? "" : "no "));
            }
            if (process) {
                response.addHeader(field);
                HttpHeader fieldHeader = field.getHeader();
                if (fieldHeader != null) {
                    switch (fieldHeader) {
                        case SET_COOKIE: 
                        case SET_COOKIE2: {
                            URI uri = exchange.getRequest().getURI();
                            if (uri == null) break;
                            this.storeCookie(uri, field);
                        }
                    }
                }
            }
        });
    }

    protected void storeCookie(URI uri, HttpField field) {
        block3: {
            try {
                String value = field.getValue();
                if (value != null) {
                    HashMap<String, List<String>> header = new HashMap<String, List<String>>(1);
                    header.put(field.getHeader().asString(), Collections.singletonList(value));
                    this.getHttpDestination().getHttpClient().getCookieManager().put(uri, header);
                }
            }
            catch (IOException x) {
                if (!LOG.isDebugEnabled()) break block3;
                LOG.debug("Unable to store cookies {} from {}", new Object[]{field, uri, x});
            }
        }
    }

    protected void responseHeaders(HttpExchange exchange) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseHeaders on {}", (Object)this);
        }
        this.invoker.run(() -> {
            List contentEncodings;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseHeaders on {}", (Object)this);
            }
            if (exchange.isResponseComplete()) {
                return;
            }
            this.responseState = ResponseState.HEADERS;
            HttpResponse response = exchange.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response headers {}{}{}", new Object[]{response, System.lineSeparator(), response.getHeaders().toString().trim()});
            }
            ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
            List<Response.ResponseListener> responseListeners = exchange.getConversation().getResponseListeners();
            notifier.notifyHeaders(responseListeners, (Response)response);
            if (exchange.isResponseComplete()) {
                return;
            }
            if (HttpStatus.isInterim((int)response.getStatus())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Interim response status {}, succeeding", (Object)response.getStatus());
                }
                this.responseSuccess(exchange, this::onInterim);
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Switching to CONTENT state for {} on {}", (Object)response, (Object)this);
            }
            this.responseState = ResponseState.CONTENT;
            if (this.contentSource != null) {
                throw new IllegalStateException();
            }
            this.contentSource = new ContentSource();
            List<Response.ContentSourceListener> contentListeners = responseListeners.stream().filter(l -> l instanceof Response.ContentSourceListener).map(Response.ContentSourceListener.class::cast).toList();
            if (!contentListeners.isEmpty() && (contentEncodings = response.getHeaders().getCSV(HttpHeader.CONTENT_ENCODING.asString(), false)) != null && !contentEncodings.isEmpty()) {
                block0: for (ContentDecoder.Factory factory : this.getHttpDestination().getHttpClient().getContentDecoderFactories()) {
                    for (String encoding : contentEncodings) {
                        if (!factory.getEncoding().equalsIgnoreCase(encoding)) continue;
                        this.contentSource = new DecodingContentSource(this.contentSource, factory.newContentDecoder(), this.invoker);
                        break block0;
                    }
                }
            }
            notifier.notifyContent(response, this.contentSource, contentListeners);
        });
    }

    protected void responseContentAvailable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response content available on {}", (Object)this);
        }
        this.contentSource.onDataAvailable();
    }

    protected void responseSuccess(HttpExchange exchange, Runnable afterSuccessTask) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking responseSuccess on {}", (Object)this);
        }
        if (!exchange.responseComplete(null)) {
            return;
        }
        this.invoker.run(new Runnable[]{() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing responseSuccess on {}", (Object)this);
            }
            this.responseState = ResponseState.IDLE;
            this.reset();
            HttpResponse response = exchange.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response success {}", (Object)response);
            }
            List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
            ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
            notifier.notifySuccess(listeners, (Response)response);
            if (HttpStatus.isInterim((int)exchange.getResponse().getStatus())) {
                return;
            }
            this.terminateResponse(exchange);
        }, afterSuccessTask});
    }

    protected void responseFailure(Throwable failure, Promise<Boolean> promise) {
        HttpExchange exchange;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Failing with {} on {}", (Object)failure, (Object)this);
        }
        if ((exchange = this.getHttpExchange()) == null) {
            promise.succeeded((Object)false);
            return;
        }
        boolean completed = exchange.responseComplete(failure);
        if (completed) {
            this.abort(exchange, failure, promise);
        } else {
            promise.succeeded((Object)false);
        }
    }

    private void terminateResponse(HttpExchange exchange) {
        Result result = exchange.terminateResponse();
        this.terminateResponse(exchange, result);
    }

    private void terminateResponse(HttpExchange exchange, Result result) {
        HttpResponse response = exchange.getResponse();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Response complete {}, result: {}", (Object)response, (Object)result);
        }
        if (result != null) {
            result = this.channel.exchangeTerminating(exchange, result);
            boolean ordered = this.getHttpDestination().getHttpClient().isStrictEventOrdering();
            if (!ordered) {
                this.channel.exchangeTerminated(exchange, result);
            }
            List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request/Response {}: {}, notifying {}", new Object[]{this.failure == null ? "succeeded" : "failed", result, listeners});
            }
            ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
            notifier.notifyComplete(listeners, result);
            if (ordered) {
                this.channel.exchangeTerminated(exchange, result);
            }
        }
    }

    protected void reset() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resetting {}", (Object)this);
        }
        this.cleanup();
    }

    protected void dispose() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disposing {}", (Object)this);
        }
        this.cleanup();
    }

    private void cleanup() {
        this.contentSource = null;
    }

    public void abort(HttpExchange exchange, Throwable failure, Promise<Boolean> promise) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Invoking abort with {} on {}", (Object)failure, (Object)this);
        }
        if (!exchange.isResponseComplete()) {
            throw new IllegalStateException();
        }
        this.invoker.run(() -> {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Executing abort with {} on {}", (Object)failure, (Object)this);
            }
            if (this.responseState == ResponseState.FAILURE) {
                promise.succeeded((Object)false);
                return;
            }
            this.responseState = ResponseState.FAILURE;
            this.failure = failure;
            if (this.contentSource != null) {
                this.contentSource.error(failure);
            }
            this.dispose();
            HttpResponse response = exchange.getResponse();
            if (LOG.isDebugEnabled()) {
                LOG.debug("Response abort {} {} on {}: {}", new Object[]{response, exchange, this.getHttpChannel(), failure});
            }
            List<Response.ResponseListener> listeners = exchange.getConversation().getResponseListeners();
            ResponseNotifier notifier = this.getHttpDestination().getResponseNotifier();
            notifier.notifyFailure(listeners, (Response)response, failure);
            this.terminateResponse(exchange);
            promise.succeeded((Object)true);
        });
    }

    public String toString() {
        return String.format("%s@%x(ex=%s,rsp=%s,failure=%s)", new Object[]{this.getClass().getSimpleName(), this.hashCode(), this.getHttpExchange(), this.responseState, this.failure});
    }

    private static enum ResponseState {
        IDLE,
        BEGIN,
        HEADER,
        HEADERS,
        CONTENT,
        FAILURE;

    }

    private static interface NotifiableContentSource
    extends Content.Source {
        public boolean error(Throwable var1);

        public void onDataAvailable();
    }

    private class ContentSource
    implements NotifiableContentSource {
        private static final Logger LOG = LoggerFactory.getLogger(ContentSource.class);
        private final AtomicReference<Runnable> demandCallbackRef = new AtomicReference();
        private final AutoLock lock = new AutoLock();
        private Content.Chunk currentChunk;

        private ContentSource() {
        }

        public Content.Chunk read() {
            Content.Chunk current;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Reading from {}", (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                current = this.currentChunk;
                this.currentChunk = Content.Chunk.next((Content.Chunk)current);
                if (current != null) {
                    Content.Chunk chunk = current;
                    return chunk;
                }
            }
            current = HttpReceiver.this.read(false);
            ignored = this.lock.lock();
            try {
                if (this.currentChunk != null) {
                    if (current != null) {
                        current.release();
                    }
                    Content.Chunk chunk = this.currentChunk;
                    return chunk;
                }
                this.currentChunk = Content.Chunk.next((Content.Chunk)current);
                Content.Chunk chunk = current;
                return chunk;
            }
            finally {
                if (ignored != null) {
                    ignored.close();
                }
            }
        }

        @Override
        public void onDataAvailable() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onDataAvailable on {}", (Object)this);
            }
            this.invokeDemandCallback(true);
        }

        public void demand(Runnable demandCallback) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering demand on {}", (Object)this);
            }
            if (demandCallback == null) {
                throw new IllegalArgumentException();
            }
            if (!this.demandCallbackRef.compareAndSet(null, demandCallback)) {
                throw new IllegalStateException();
            }
            HttpReceiver.this.invoker.run(this::processDemand);
        }

        private void processDemand() {
            Content.Chunk current;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing demand on {}", (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                current = this.currentChunk;
            }
            if (current == null) {
                current = HttpReceiver.this.read(true);
                if (current == null) {
                    return;
                }
                ignored = this.lock.lock();
                try {
                    if (this.currentChunk != null) {
                        current.release();
                        return;
                    }
                    this.currentChunk = current;
                }
                finally {
                    if (ignored != null) {
                        ignored.close();
                    }
                }
            }
            this.invokeDemandCallback(false);
        }

        private void invokeDemandCallback(boolean invoke) {
            Runnable demandCallback = this.demandCallbackRef.getAndSet(null);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Invoking demand callback on {}", (Object)this);
            }
            if (demandCallback != null) {
                try {
                    if (invoke) {
                        HttpReceiver.this.invoker.run(demandCallback);
                    } else {
                        demandCallback.run();
                    }
                }
                catch (Throwable x) {
                    this.fail(x);
                }
            }
        }

        public void fail(Throwable failure) {
            boolean failed;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Failing {}", (Object)this);
            }
            if (failed = this.error(failure)) {
                HttpReceiver.this.failAndClose(failure);
            }
            this.invokeDemandCallback(true);
        }

        @Override
        public boolean error(Throwable failure) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Erroring {}", (Object)this);
            }
            try (AutoLock ignored = this.lock.lock();){
                if (this.currentChunk instanceof Content.Chunk.Error) {
                    boolean bl = false;
                    return bl;
                }
                if (this.currentChunk != null) {
                    this.currentChunk.release();
                }
                this.currentChunk = Content.Chunk.from((Throwable)failure);
            }
            return true;
        }

        private Content.Chunk chunk() {
            try (AutoLock ignored = this.lock.lock();){
                Content.Chunk chunk = this.currentChunk;
                return chunk;
            }
        }

        public String toString() {
            return String.format("%s@%x{c=%s,d=%s}", this.getClass().getSimpleName(), this.hashCode(), this.chunk(), this.demandCallbackRef);
        }
    }

    private static class DecodingContentSource
    extends ContentSourceTransformer
    implements NotifiableContentSource {
        private static final Logger LOG = LoggerFactory.getLogger(DecodingContentSource.class);
        private final NotifiableContentSource _rawSource;
        private final ContentDecoder _decoder;
        private volatile Content.Chunk _chunk;

        public DecodingContentSource(NotifiableContentSource rawSource, ContentDecoder decoder, SerializedInvoker invoker) {
            super((Content.Source)rawSource, invoker);
            this._rawSource = rawSource;
            this._decoder = decoder;
        }

        @Override
        public void onDataAvailable() {
            this._rawSource.onDataAvailable();
        }

        protected Content.Chunk transform(Content.Chunk inputChunk) {
            while (true) {
                boolean retain;
                boolean bl = retain = this._chunk == null;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("input: {}, chunk: {}, retain? {}", new Object[]{inputChunk, this._chunk, retain});
                }
                if (this._chunk == null) {
                    this._chunk = inputChunk;
                }
                if (this._chunk == null) {
                    return null;
                }
                if (this._chunk instanceof Content.Chunk.Error) {
                    return this._chunk;
                }
                if (retain && this._chunk.hasRemaining()) {
                    this._chunk.retain();
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("decoding: {}", (Object)this._chunk);
                }
                ByteBuffer decodedBuffer = this._decoder.decode(this._chunk.getByteBuffer());
                if (LOG.isDebugEnabled()) {
                    LOG.debug("decoded: {}", (Object)BufferUtil.toDetailString((ByteBuffer)decodedBuffer));
                }
                if (BufferUtil.hasContent((ByteBuffer)decodedBuffer)) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("returning decoded content");
                    }
                    return Content.Chunk.from((ByteBuffer)decodedBuffer, (boolean)false, this._decoder::release);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("decoding produced no content");
                }
                if (!this._chunk.hasRemaining()) {
                    Content.Chunk result;
                    Object object = result = this._chunk.isLast() ? Content.Chunk.EOF : null;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not decode more from this chunk, releasing it, r={}", (Object)result);
                    }
                    this._chunk.release();
                    this._chunk = null;
                    return result;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("retrying transformation");
            }
        }

        @Override
        public boolean error(Throwable failure) {
            if (this._chunk != null) {
                this._chunk.release();
            }
            this._chunk = null;
            return this._rawSource.error(failure);
        }
    }
}

