/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.util.List;
import org.eclipse.jetty.client.HttpContentResponse;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.ResponseNotifier;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.client.util.BufferingResponseListener;
import org.eclipse.jetty.http.HttpFields;

public class EarlyHintsProtocolHandler
implements ProtocolHandler {
    public static final String NAME = "early-hints";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request, Response response) {
        return response.getStatus() == 103;
    }

    @Override
    public Response.Listener getResponseListener() {
        return new EarlyHintsListener();
    }

    protected void onEarlyHints(Request request, HttpFields responseHeaders) {
    }

    private class EarlyHintsListener
    extends BufferingResponseListener {
        private final ResponseNotifier notifier = new ResponseNotifier();

        private EarlyHintsListener() {
        }

        @Override
        public void onSuccess(Response response) {
            Request request = response.getRequest();
            HttpConversation conversation = ((HttpRequest)request).getConversation();
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            assert (exchange != null);
            HttpFields.Mutable responseHeaders = HttpFields.build((HttpFields)response.getHeaders());
            exchange.resetResponse();
            EarlyHintsProtocolHandler.this.onEarlyHints(request, (HttpFields)responseHeaders);
        }

        @Override
        public void onFailure(Response response, Throwable failure) {
            HttpConversation conversation = ((HttpRequest)response.getRequest()).getConversation();
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            if (exchange != null) {
                List<Response.ResponseListener> listeners = exchange.getResponseListeners();
                HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
                this.notifier.forwardFailureComplete(listeners, exchange.getRequest(), exchange.getRequestFailure(), contentResponse, failure);
            }
        }

        @Override
        public void onComplete(Result result) {
        }
    }
}

