/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.jetty.client.api.ContentResponse;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.CountingCallback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ResponseNotifier {
    private static final Logger LOG = Log.getLogger(ResponseNotifier.class);

    public void notifyBegin(List<Response.ResponseListener> listeners, Response response) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.BeginListener)) continue;
            this.notifyBegin((Response.BeginListener)listener, response);
        }
    }

    private void notifyBegin(Response.BeginListener listener, Response response) {
        try {
            listener.onBegin(response);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public boolean notifyHeader(List<Response.ResponseListener> listeners, Response response, HttpField field) {
        boolean result = true;
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.HeaderListener)) continue;
            result &= this.notifyHeader((Response.HeaderListener)listener, response, field);
        }
        return result;
    }

    private boolean notifyHeader(Response.HeaderListener listener, Response response, HttpField field) {
        try {
            return listener.onHeader(response, field);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
            return false;
        }
    }

    public void notifyHeaders(List<Response.ResponseListener> listeners, Response response) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.HeadersListener)) continue;
            this.notifyHeaders((Response.HeadersListener)listener, response);
        }
    }

    private void notifyHeaders(Response.HeadersListener listener, Response response) {
        try {
            listener.onHeaders(response);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifyContent(List<Response.ResponseListener> listeners, Response response, ByteBuffer buffer, Callback callback) {
        List<Response.AsyncContentListener> contentListeners = listeners.stream().filter(Response.AsyncContentListener.class::isInstance).map(Response.AsyncContentListener.class::cast).collect(Collectors.toList());
        this.notifyContent(response, buffer, callback, contentListeners);
    }

    public void notifyContent(Response response, ByteBuffer buffer, Callback callback, List<Response.AsyncContentListener> contentListeners) {
        if (contentListeners.isEmpty()) {
            callback.succeeded();
        } else {
            CountingCallback counter = new CountingCallback(callback, contentListeners.size());
            for (Response.AsyncContentListener listener : contentListeners) {
                this.notifyContent(listener, response, buffer.slice(), (Callback)counter);
            }
        }
    }

    private void notifyContent(Response.AsyncContentListener listener, Response response, ByteBuffer buffer, Callback callback) {
        try {
            listener.onContent(response, buffer, callback);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifySuccess(List<Response.ResponseListener> listeners, Response response) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.SuccessListener)) continue;
            this.notifySuccess((Response.SuccessListener)listener, response);
        }
    }

    private void notifySuccess(Response.SuccessListener listener, Response response) {
        try {
            listener.onSuccess(response);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifyFailure(List<Response.ResponseListener> listeners, Response response, Throwable failure) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.FailureListener)) continue;
            this.notifyFailure((Response.FailureListener)listener, response, failure);
        }
    }

    private void notifyFailure(Response.FailureListener listener, Response response, Throwable failure) {
        try {
            listener.onFailure(response, failure);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void notifyComplete(List<Response.ResponseListener> listeners, Result result) {
        for (Response.ResponseListener listener : listeners) {
            if (!(listener instanceof Response.CompleteListener)) continue;
            this.notifyComplete((Response.CompleteListener)listener, result);
        }
    }

    private void notifyComplete(Response.CompleteListener listener, Result result) {
        try {
            listener.onComplete(result);
        }
        catch (Throwable x) {
            LOG.info("Exception while notifying listener " + listener, x);
        }
    }

    public void forwardSuccess(List<Response.ResponseListener> listeners, Response response) {
        this.forwardEvents(listeners, response);
        this.notifySuccess(listeners, response);
    }

    public void forwardSuccessComplete(List<Response.ResponseListener> listeners, Request request, Response response) {
        this.forwardSuccess(listeners, response);
        this.notifyComplete(listeners, new Result(request, response));
    }

    public void forwardFailure(List<Response.ResponseListener> listeners, Response response, Throwable failure) {
        this.forwardEvents(listeners, response);
        this.notifyFailure(listeners, response, failure);
    }

    private void forwardEvents(List<Response.ResponseListener> listeners, Response response) {
        byte[] content;
        this.notifyBegin(listeners, response);
        Iterator iterator = response.getHeaders().iterator();
        while (iterator.hasNext()) {
            HttpField field = (HttpField)iterator.next();
            if (this.notifyHeader(listeners, response, field)) continue;
            iterator.remove();
        }
        this.notifyHeaders(listeners, response);
        if (response instanceof ContentResponse && (content = ((ContentResponse)response).getContent()) != null && content.length > 0) {
            this.notifyContent(listeners, response, ByteBuffer.wrap(content), Callback.NOOP);
        }
    }

    public void forwardFailureComplete(List<Response.ResponseListener> listeners, Request request, Throwable requestFailure, Response response, Throwable responseFailure) {
        this.forwardFailure(listeners, response, responseFailure);
        this.notifyComplete(listeners, new Result(request, requestFailure, response, responseFailure));
    }
}

