/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.annotations;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jetty.annotations.AnnotationParser;
import org.eclipse.jetty.annotations.ClassNameResolver;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.webapp.Configuration;
import org.eclipse.jetty.webapp.Descriptor;
import org.eclipse.jetty.webapp.FragmentDescriptor;
import org.eclipse.jetty.webapp.MetaData;
import org.eclipse.jetty.webapp.WebAppContext;

public abstract class AbstractConfiguration
implements Configuration {
    public static final String CONTAINER_JAR_RESOURCES = "org.eclipse.jetty.containerJars";
    public static final String WEB_INF_JAR_RESOURCES = "org.eclipse.jetty.webInfJars";
    public static final String WEB_INF_ORDERED_JAR_RESOURCES = "org.eclipse.jetty.webInfOrderedJars";
    public static final String METADATA_COMPLETE = "org.eclipse.jetty.metadataComplete";
    public static final String WEBXML_CLASSNAMES = "org.eclipse.jetty.webXmlClassNames";
    public static final String DISCOVERED_ANNOTATIONS = "org.eclipse.jetty.discoveredAnnotations";

    public void parseContainerPath(final WebAppContext context, AnnotationParser parser) throws Exception {
        Log.debug((String)"Scanning container jars");
        ArrayList discoveredAnnotations = new ArrayList();
        context.setAttribute(DISCOVERED_ANNOTATIONS, discoveredAnnotations);
        ArrayList<URI> containerUris = new ArrayList<URI>();
        List jarResources = (List)context.getAttribute(CONTAINER_JAR_RESOURCES);
        for (Resource r : jarResources) {
            URI uri = r.getURI();
            containerUris.add(uri);
        }
        parser.parse(containerUris.toArray(new URI[containerUris.size()]), new ClassNameResolver(){

            @Override
            public boolean isExcluded(String name) {
                if (context.isSystemClass(name)) {
                    return false;
                }
                return context.isServerClass(name);
            }

            @Override
            public boolean shouldOverride(String name) {
                return context.isParentLoaderPriority();
            }
        });
        MetaData metaData = (MetaData)context.getAttribute("org.eclipse.jetty.metaData");
        if (metaData == null) {
            throw new IllegalStateException("No metadata");
        }
        metaData.addDiscoveredAnnotations((List)context.getAttribute(DISCOVERED_ANNOTATIONS));
        context.removeAttribute(DISCOVERED_ANNOTATIONS);
    }

    public void parseWebInfLib(final WebAppContext context, AnnotationParser parser) throws Exception {
        MetaData metaData = (MetaData)context.getAttribute("org.eclipse.jetty.metaData");
        if (metaData == null) {
            throw new IllegalStateException("No metadata");
        }
        List frags = metaData.getFragments();
        ArrayList webInfUris = new ArrayList();
        List jars = (List)context.getAttribute(WEB_INF_ORDERED_JAR_RESOURCES);
        if (jars == null || jars.isEmpty()) {
            jars = (List)context.getAttribute(WEB_INF_JAR_RESOURCES);
        }
        ArrayList discoveredAnnotations = new ArrayList();
        context.setAttribute(DISCOVERED_ANNOTATIONS, discoveredAnnotations);
        for (Resource r : jars) {
            discoveredAnnotations.clear();
            URI uri = r.getURI();
            FragmentDescriptor f = this.getFragmentFromJar(r, frags);
            if (f != null && this.isMetaDataComplete((Descriptor)f)) continue;
            parser.parse(uri, new ClassNameResolver(){

                @Override
                public boolean isExcluded(String name) {
                    if (context.isSystemClass(name)) {
                        return true;
                    }
                    if (context.isServerClass(name)) {
                        return false;
                    }
                    return false;
                }

                @Override
                public boolean shouldOverride(String name) {
                    return !context.isParentLoaderPriority();
                }
            });
            metaData.addDiscoveredAnnotations(r, discoveredAnnotations);
        }
        context.removeAttribute(DISCOVERED_ANNOTATIONS);
    }

    public void parseWebInfClasses(final WebAppContext context, AnnotationParser parser) throws Exception {
        Resource classesDir;
        Log.debug((String)"Scanning classes in WEB-INF/classes");
        if (context.getWebInf() != null && (classesDir = context.getWebInf().addPath("classes/")).exists()) {
            MetaData metaData = (MetaData)context.getAttribute("org.eclipse.jetty.metaData");
            if (metaData == null) {
                throw new IllegalStateException("No metadata");
            }
            ArrayList discoveredAnnotations = new ArrayList();
            context.setAttribute(DISCOVERED_ANNOTATIONS, discoveredAnnotations);
            parser.parse(classesDir, new ClassNameResolver(){

                @Override
                public boolean isExcluded(String name) {
                    if (context.isSystemClass(name)) {
                        return true;
                    }
                    if (context.isServerClass(name)) {
                        return false;
                    }
                    return false;
                }

                @Override
                public boolean shouldOverride(String name) {
                    return !context.isParentLoaderPriority();
                }
            });
            metaData.addDiscoveredAnnotations(discoveredAnnotations);
            context.removeAttribute(DISCOVERED_ANNOTATIONS);
        }
    }

    public FragmentDescriptor getFragmentFromJar(Resource jar, List<FragmentDescriptor> frags) throws Exception {
        FragmentDescriptor d = null;
        for (FragmentDescriptor frag : frags) {
            Resource fragResource = frag.getResource();
            if (!Resource.isContainedIn((Resource)fragResource, (Resource)jar)) continue;
            d = frag;
            break;
        }
        return d;
    }

    public boolean isMetaDataComplete(Descriptor d) {
        return d != null && d.getMetaDataComplete() == Descriptor.MetaDataComplete.True;
    }
}

