/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.openjdk8.client;

import java.util.List;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.ALPN;
import org.eclipse.jetty.alpn.client.ALPNClientConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.util.JavaVersion;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class OpenJDK8ClientALPNProcessor
implements ALPNProcessor.Client {
    private static final Logger LOG = Log.getLogger(OpenJDK8ClientALPNProcessor.class);

    public void init() {
        if (JavaVersion.VERSION.getPlatform() != 8) {
            throw new IllegalStateException(this + " not applicable for java " + JavaVersion.VERSION);
        }
        if (ALPN.class.getClassLoader() != null) {
            throw new IllegalStateException(ALPN.class.getName() + " must be on JVM boot classpath");
        }
        if (LOG.isDebugEnabled()) {
            ALPN.debug = true;
        }
    }

    public boolean appliesTo(SSLEngine sslEngine) {
        return sslEngine.getClass().getName().startsWith("sun.security.ssl.");
    }

    public void configure(SSLEngine sslEngine, Connection connection) {
        connection.addListener((Connection.Listener)new ALPNListener((ALPNClientConnection)connection));
    }

    private final class ALPNListener
    implements ALPN.ClientProvider,
    Connection.Listener {
        private final ALPNClientConnection alpnConnection;

        private ALPNListener(ALPNClientConnection connection) {
            this.alpnConnection = connection;
        }

        public void onOpened(Connection connection) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onOpened {}", new Object[]{this.alpnConnection});
            }
            ALPN.put((SSLEngine)this.alpnConnection.getSSLEngine(), (ALPN.Provider)this);
        }

        public void onClosed(Connection connection) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onClosed {}", new Object[]{this.alpnConnection});
            }
            ALPN.remove((SSLEngine)this.alpnConnection.getSSLEngine());
        }

        public List<String> protocols() {
            return this.alpnConnection.getProtocols();
        }

        public void unsupported() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("unsupported {}", new Object[]{this.alpnConnection});
            }
            ALPN.remove((SSLEngine)this.alpnConnection.getSSLEngine());
            this.alpnConnection.selected(null);
        }

        public void selected(String protocol) {
            this.alpnConnection.selected(protocol);
        }
    }
}

