/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.bouncycastle.server;

import java.util.List;
import java.util.function.BiFunction;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.alpn.server.ALPNServerConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BouncyCastleServerALPNProcessor
implements ALPNProcessor.Server {
    private static final Logger LOG = LoggerFactory.getLogger(BouncyCastleServerALPNProcessor.class);

    public boolean appliesTo(SSLEngine sslEngine) {
        return sslEngine.getClass().getName().startsWith("org.bouncycastle.jsse.provider.");
    }

    public void configure(SSLEngine sslEngine, Connection connection) {
        sslEngine.setHandshakeApplicationProtocolSelector(new ALPNCallback((ALPNServerConnection)connection));
    }

    private final class ALPNCallback
    implements BiFunction<SSLEngine, List<String>, String>,
    SslHandshakeListener {
        private final ALPNServerConnection alpnConnection;

        private ALPNCallback(ALPNServerConnection connection) {
            this.alpnConnection = connection;
            SslConnection.SslEndPoint sslEndPoint = (SslConnection.SslEndPoint)this.alpnConnection.getEndPoint();
            sslEndPoint.getSslConnection().addHandshakeListener((SslHandshakeListener)this);
        }

        @Override
        public String apply(SSLEngine engine, List<String> protocols) {
            try {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("apply {} {}", (Object)this.alpnConnection, protocols);
                }
                this.alpnConnection.select(protocols);
                return this.alpnConnection.getProtocol();
            }
            catch (Throwable x) {
                return null;
            }
        }

        public void handshakeSucceeded(SslHandshakeListener.Event event) {
            String protocol = this.alpnConnection.getProtocol();
            if (LOG.isDebugEnabled()) {
                LOG.debug("TLS handshake succeeded, protocol={} for {}", (Object)protocol, (Object)this.alpnConnection);
            }
            if (protocol == null) {
                this.alpnConnection.unsupported();
            }
        }

        public void handshakeFailed(SslHandshakeListener.Event event, Throwable failure) {
            if (LOG.isDebugEnabled()) {
                LOG.atDebug().setCause(failure).log("TLS handshake failed {}", (Object)this.alpnConnection);
            }
        }
    }
}

