/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.alpn.bouncycastle.client;

import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.eclipse.jetty.alpn.client.ALPNClientConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.ssl.ALPNProcessor;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.io.ssl.SslHandshakeListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BouncyCastleClientALPNProcessor
implements ALPNProcessor.Client {
    private static final Logger LOG = LoggerFactory.getLogger(BouncyCastleClientALPNProcessor.class);

    public boolean appliesTo(SSLEngine sslEngine) {
        return sslEngine.getClass().getName().startsWith("org.bouncycastle.jsse.provider.");
    }

    public void configure(SSLEngine sslEngine, Connection connection) {
        try {
            ALPNClientConnection alpn = (ALPNClientConnection)connection;
            SSLParameters sslParameters = sslEngine.getSSLParameters();
            List protocols = alpn.getProtocols();
            sslParameters.setApplicationProtocols(protocols.toArray(new String[0]));
            sslEngine.setSSLParameters(sslParameters);
            SslConnection.SslEndPoint sslEndPoint = (SslConnection.SslEndPoint)connection.getEndPoint();
            sslEndPoint.getSslConnection().addHandshakeListener((SslHandshakeListener)new ALPNListener(alpn));
        }
        catch (RuntimeException x) {
            throw x;
        }
        catch (Exception x) {
            throw new RuntimeException(x);
        }
    }

    private final class ALPNListener
    implements SslHandshakeListener {
        private final ALPNClientConnection alpnConnection;

        private ALPNListener(ALPNClientConnection connection) {
            this.alpnConnection = connection;
        }

        public void handshakeSucceeded(SslHandshakeListener.Event event) {
            try {
                SSLEngine sslEngine = this.alpnConnection.getSSLEngine();
                String protocol = sslEngine.getApplicationProtocol();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Selected {} for {}", (Object)protocol, (Object)this.alpnConnection);
                }
                this.alpnConnection.selected(protocol);
            }
            catch (Throwable e) {
                LOG.warn("Unable to process BouncyCastle ApplicationProtocol for {}", (Object)this.alpnConnection, (Object)e);
                this.alpnConnection.selected(null);
            }
        }
    }
}

