/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.client;

import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http3.HTTP3ErrorCode;
import org.eclipse.jetty.http3.HTTP3Session;
import org.eclipse.jetty.http3.api.Session;
import org.eclipse.jetty.http3.api.Stream;
import org.eclipse.jetty.http3.client.ClientHTTP3Session;
import org.eclipse.jetty.http3.client.HTTP3StreamClient;
import org.eclipse.jetty.http3.frames.Frame;
import org.eclipse.jetty.http3.frames.GoAwayFrame;
import org.eclipse.jetty.http3.frames.HeadersFrame;
import org.eclipse.jetty.http3.frames.SettingsFrame;
import org.eclipse.jetty.quic.common.ProtocolSession;
import org.eclipse.jetty.quic.common.QuicStreamEndPoint;
import org.eclipse.jetty.quic.common.StreamType;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP3SessionClient
extends HTTP3Session
implements Session.Client {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP3SessionClient.class);
    private final Promise<Session.Client> promise;

    public HTTP3SessionClient(ClientHTTP3Session session, Session.Client.Listener listener, Promise<Session.Client> promise) {
        super((ProtocolSession)session, (Session.Listener)listener);
        this.promise = promise;
    }

    public ClientHTTP3Session getProtocolSession() {
        return (ClientHTTP3Session)super.getProtocolSession();
    }

    public void onOpen() {
        super.onOpen();
        if (this.promise != null) {
            this.promise.succeeded((Object)this);
        }
    }

    protected HTTP3StreamClient newHTTP3Stream(QuicStreamEndPoint endPoint, boolean local) {
        return new HTTP3StreamClient(this, endPoint, local);
    }

    public void onHeaders(long streamId, HeadersFrame frame, boolean wasBlocked) {
        if (frame.getMetaData().isResponse()) {
            QuicStreamEndPoint endPoint = this.getProtocolSession().getStreamEndPoint(streamId);
            HTTP3StreamClient stream = (HTTP3StreamClient)this.getOrCreateStream(endPoint);
            if (LOG.isDebugEnabled()) {
                LOG.debug("received response {} on {}", (Object)frame, (Object)stream);
            }
            if (stream != null) {
                stream.onResponse(frame);
            }
        } else {
            super.onHeaders(streamId, frame, wasBlocked);
        }
    }

    public void onSettings(SettingsFrame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("received {} on {}", (Object)frame, (Object)this);
        }
        this.getProtocolSession().onSettings(frame);
        super.onSettings(frame);
    }

    public CompletableFuture<Stream> newRequest(HeadersFrame frame, Stream.Client.Listener listener) {
        long streamId = this.getProtocolSession().newStreamId(StreamType.CLIENT_BIDIRECTIONAL);
        return this.newRequest(streamId, frame, listener);
    }

    private CompletableFuture<Stream> newRequest(long streamId, HeadersFrame frame, Stream.Client.Listener listener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("new request stream #{} with {} on {}", new Object[]{streamId, frame, this});
        }
        ClientHTTP3Session session = this.getProtocolSession();
        QuicStreamEndPoint endPoint = session.getOrCreateStreamEndPoint(streamId, arg_0 -> ((ProtocolSession)session).openProtocolEndPoint(arg_0));
        Promise.Completable promise = new Promise.Completable();
        promise.whenComplete((s, x) -> {
            if (x != null) {
                endPoint.close(HTTP3ErrorCode.REQUEST_CANCELLED_ERROR.code(), x);
            }
        });
        HTTP3StreamClient stream = (HTTP3StreamClient)this.createStream(endPoint, arg_0 -> ((Promise.Completable)promise).failed(arg_0));
        if (stream == null) {
            return promise;
        }
        stream.setListener(listener);
        stream.onOpen();
        stream.writeFrame((Frame)frame).whenComplete((r, x) -> {
            if (x == null) {
                stream.updateClose(frame.isLast(), true);
                promise.succeeded((Object)stream);
            } else {
                this.removeStream(stream, (Throwable)x);
                promise.failed(x);
            }
        });
        return promise;
    }

    public void writeControlFrame(Frame frame, Callback callback) {
        this.getProtocolSession().writeControlFrame(frame, callback);
    }

    public void writeMessageFrame(long streamId, Frame frame, Callback callback) {
        this.getProtocolSession().writeMessageFrame(streamId, frame, callback);
    }

    protected GoAwayFrame newGoAwayFrame(boolean graceful) {
        if (graceful) {
            return GoAwayFrame.CLIENT_GRACEFUL;
        }
        return super.newGoAwayFrame(graceful);
    }
}

