/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.instruction;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http3.qpack.Instruction;
import org.eclipse.jetty.http3.qpack.internal.util.HuffmanEncoder;
import org.eclipse.jetty.http3.qpack.internal.util.NBitIntegerEncoder;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;

public class LiteralNameEntryInstruction
implements Instruction {
    private final boolean _huffmanName;
    private final boolean _huffmanValue;
    private final String _name;
    private final String _value;

    public LiteralNameEntryInstruction(HttpField httpField, boolean huffman) {
        this(httpField, huffman, huffman);
    }

    public LiteralNameEntryInstruction(HttpField httpField, boolean huffmanName, boolean huffmanValue) {
        this._huffmanName = huffmanName;
        this._huffmanValue = huffmanValue;
        this._name = httpField.getName();
        this._value = httpField.getValue();
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._value;
    }

    @Override
    public void encode(ByteBufferPool.Lease lease) {
        int size = (this._huffmanName ? HuffmanEncoder.octetsNeeded(this._name) : this._name.length()) + (this._huffmanValue ? HuffmanEncoder.octetsNeeded(this._value) : this._value.length()) + 2;
        ByteBuffer buffer = lease.acquire(size, false);
        if (this._huffmanName) {
            buffer.put((byte)96);
            NBitIntegerEncoder.encode(buffer, 5, HuffmanEncoder.octetsNeeded(this._name));
            HuffmanEncoder.encode(buffer, this._name);
        } else {
            buffer.put((byte)64);
            NBitIntegerEncoder.encode(buffer, 5, this._name.length());
            buffer.put(this._name.getBytes());
        }
        if (this._huffmanValue) {
            buffer.put((byte)-128);
            NBitIntegerEncoder.encode(buffer, 7, HuffmanEncoder.octetsNeeded(this._value));
            HuffmanEncoder.encode(buffer, this._value);
        } else {
            buffer.put((byte)0);
            NBitIntegerEncoder.encode(buffer, 5, this._value.length());
            buffer.put(this._value.getBytes());
        }
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
        lease.append(buffer, true);
    }

    public String toString() {
        return String.format("%s@%x", this.getClass().getSimpleName(), this.hashCode());
    }
}

