/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3.qpack.internal.util;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http3.qpack.internal.util.EncodingException;
import org.eclipse.jetty.http3.qpack.internal.util.HuffmanDecoder;
import org.eclipse.jetty.http3.qpack.internal.util.NBitIntegerParser;

public class NBitStringParser {
    private final NBitIntegerParser _integerParser;
    private final HuffmanDecoder _huffmanBuilder;
    private final StringBuilder _stringBuilder;
    private boolean _huffman;
    private int _count;
    private int _length;
    private int _prefix;
    private State _state = State.PARSING;

    public NBitStringParser() {
        this._integerParser = new NBitIntegerParser();
        this._huffmanBuilder = new HuffmanDecoder();
        this._stringBuilder = new StringBuilder();
    }

    public void setPrefix(int prefix) {
        if (this._state != State.PARSING) {
            throw new IllegalStateException();
        }
        this._prefix = prefix;
    }

    public String decode(ByteBuffer buffer) throws EncodingException {
        block5: while (true) {
            switch (this._state) {
                case PARSING: {
                    byte firstByte = buffer.get(buffer.position());
                    this._huffman = (128 >>> 8 - this._prefix & firstByte) != 0;
                    this._state = State.LENGTH;
                    this._integerParser.setPrefix(this._prefix - 1);
                    continue block5;
                }
                case LENGTH: {
                    this._length = this._integerParser.decodeInt(buffer);
                    if (this._length < 0) {
                        return null;
                    }
                    this._state = State.VALUE;
                    this._huffmanBuilder.setLength(this._length);
                    continue block5;
                }
                case VALUE: {
                    String value;
                    String string = value = this._huffman ? this._huffmanBuilder.decode(buffer) : this.asciiStringDecode(buffer);
                    if (value != null) {
                        this.reset();
                    }
                    return value;
                }
            }
            break;
        }
        throw new IllegalStateException(this._state.name());
    }

    private String asciiStringDecode(ByteBuffer buffer) {
        while (this._count < this._length) {
            if (!buffer.hasRemaining()) {
                return null;
            }
            this._stringBuilder.append((char)(0x7F & buffer.get()));
            ++this._count;
        }
        return this._stringBuilder.toString();
    }

    public void reset() {
        this._state = State.PARSING;
        this._integerParser.reset();
        this._huffmanBuilder.reset();
        this._stringBuilder.setLength(0);
        this._prefix = 0;
        this._count = 0;
        this._length = 0;
        this._huffman = false;
    }

    private static enum State {
        PARSING,
        LENGTH,
        VALUE;

    }
}

