/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http3;

import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject
public class HTTP3Configuration {
    private long streamIdleTimeout = 30000L;
    private int inputBufferSize = 2048;
    private int outputBufferSize = 2048;
    private boolean useInputDirectByteBuffers = true;
    private boolean useOutputDirectByteBuffers = true;
    private int maxBlockedStreams = 64;
    private int maxDecoderTableCapacity = 65536;
    private int maxEncoderTableCapacity = 65536;
    private int maxRequestHeadersSize = 8192;
    private int maxResponseHeadersSize = 8192;

    @ManagedAttribute(value="The stream idle timeout in milliseconds")
    public long getStreamIdleTimeout() {
        return this.streamIdleTimeout;
    }

    public void setStreamIdleTimeout(long streamIdleTimeout) {
        this.streamIdleTimeout = streamIdleTimeout;
    }

    @ManagedAttribute(value="The size of the network input buffer")
    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public void setInputBufferSize(int inputBufferSize) {
        this.inputBufferSize = inputBufferSize;
    }

    @ManagedAttribute(value="The size of the network output buffer")
    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public void setOutputBufferSize(int outputBufferSize) {
        this.outputBufferSize = outputBufferSize;
    }

    @ManagedAttribute(value="Whether to use direct buffers for network reads")
    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    @ManagedAttribute(value="Whether to use direct buffers for network writes")
    public boolean isUseOutputDirectByteBuffers() {
        return this.useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this.useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    @ManagedAttribute(value="The local QPACK max decoder dynamic table capacity")
    public int getMaxDecoderTableCapacity() {
        return this.maxDecoderTableCapacity;
    }

    public void setMaxDecoderTableCapacity(int maxTableCapacity) {
        this.maxDecoderTableCapacity = maxTableCapacity;
    }

    @ManagedAttribute(value="The local QPACK initial encoder dynamic table capacity")
    public int getMaxEncoderTableCapacity() {
        return this.maxEncoderTableCapacity;
    }

    public void setMaxEncoderTableCapacity(int maxTableCapacity) {
        this.maxEncoderTableCapacity = maxTableCapacity;
    }

    @ManagedAttribute(value="The max number of QPACK blocked streams")
    public int getMaxBlockedStreams() {
        return this.maxBlockedStreams;
    }

    public void setMaxBlockedStreams(int maxBlockedStreams) {
        this.maxBlockedStreams = maxBlockedStreams;
    }

    @ManagedAttribute(value="The max size of the request headers")
    public int getMaxRequestHeadersSize() {
        return this.maxRequestHeadersSize;
    }

    public void setMaxRequestHeadersSize(int maxRequestHeadersSize) {
        this.maxRequestHeadersSize = maxRequestHeadersSize;
    }

    @ManagedAttribute(value="The max size of the response headers")
    public int getMaxResponseHeadersSize() {
        return this.maxResponseHeadersSize;
    }

    public void setMaxResponseHeadersSize(int maxResponseHeadersSize) {
        this.maxResponseHeadersSize = maxResponseHeadersSize;
    }
}

