/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server.internal;

import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.internal.ErrorCode;
import org.eclipse.jetty.http2.internal.HTTP2Channel;
import org.eclipse.jetty.http2.internal.HTTP2Stream;
import org.eclipse.jetty.http2.server.internal.HTTP2ServerConnection;
import org.eclipse.jetty.http2.server.internal.ServerHTTP2StreamEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.thread.AutoLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpStreamOverHTTP2
implements HttpStream,
HTTP2Channel.Server {
    private static final Logger LOG = LoggerFactory.getLogger(HttpStreamOverHTTP2.class);
    private final AutoLock lock = new AutoLock();
    private final HTTP2ServerConnection _connection;
    private final HttpChannel _httpChannel;
    private final HTTP2Stream _stream;
    private final long _nanoTime;
    private MetaData.Request _requestMetaData;
    private MetaData.Response _responseMetaData;
    private TunnelSupport tunnelSupport;
    private Content.Chunk _chunk;
    private boolean committed;
    private boolean _demand;
    private boolean _expects100Continue;

    public HttpStreamOverHTTP2(HTTP2ServerConnection connection, HttpChannel httpChannel, HTTP2Stream stream) {
        this._connection = connection;
        this._httpChannel = httpChannel;
        this._stream = stream;
        this._nanoTime = NanoTime.now();
    }

    public String getId() {
        return String.valueOf(this._stream.getId());
    }

    public long getNanoTimeStamp() {
        return this._nanoTime;
    }

    public Runnable onRequest(HeadersFrame frame) {
        try {
            this._requestMetaData = (MetaData.Request)frame.getMetaData();
            Runnable handler = this._httpChannel.onRequest(this._requestMetaData);
            if (frame.isEndStream()) {
                try (AutoLock ignored = this.lock.lock();){
                    this._chunk = Content.Chunk.EOF;
                }
            }
            HttpFields fields = this._requestMetaData.getFields();
            this._expects100Continue = fields.contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
            if (this._requestMetaData instanceof MetaData.ConnectRequest) {
                this.tunnelSupport = new TunnelSupportOverHTTP2(this._requestMetaData.getProtocol());
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 request #{}/{}, {} {} {}{}{}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), this._requestMetaData.getMethod(), this._requestMetaData.getURI(), this._requestMetaData.getHttpVersion(), System.lineSeparator(), fields});
            }
            return handler;
        }
        catch (BadMessageException x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onRequest", (Throwable)x);
            }
            return () -> this.onBadMessage(x);
        }
        catch (Throwable x) {
            return () -> this.onBadMessage(new BadMessageException(500, null, x));
        }
    }

    private void onBadMessage(BadMessageException x) {
    }

    public Content.Chunk read() {
        while (true) {
            Content.Chunk chunk;
            try (AutoLock ignored = this.lock.lock();){
                chunk = this._chunk;
                this._chunk = Content.Chunk.next((Content.Chunk)chunk);
            }
            if (chunk != null) {
                return chunk;
            }
            Stream.Data data = this._stream.readData();
            if (data == null) {
                return null;
            }
            chunk = this.createChunk(data);
            data.release();
            if (this._expects100Continue && chunk.hasRemaining()) {
                this._expects100Continue = false;
            }
            AutoLock ignored = this.lock.lock();
            try {
                this._chunk = chunk;
                continue;
            }
            finally {
                if (ignored == null) continue;
                ignored.close();
                continue;
            }
            break;
        }
    }

    public void demand() {
        boolean notify = false;
        boolean demand = false;
        try (AutoLock ignored = this.lock.lock();){
            if (this._chunk != null) {
                notify = true;
            } else if (!this._demand) {
                this._demand = true;
                demand = true;
            }
        }
        if (notify) {
            Runnable task = this._httpChannel.onContentAvailable();
            if (task != null) {
                this._connection.offerTask(task, false);
            }
        } else if (demand) {
            if (this._expects100Continue) {
                this._expects100Continue = false;
                this.send(this._requestMetaData, HttpGenerator.CONTINUE_100_INFO, false, null, Callback.NOOP);
            }
            this._stream.demand();
        }
    }

    public Runnable onDataAvailable() {
        try (AutoLock ignored = this.lock.lock();){
            this._demand = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Request #{}/{}: data available", (Object)this._stream.getId(), (Object)Integer.toHexString(this._stream.getSession().hashCode()));
        }
        return this._httpChannel.onContentAvailable();
    }

    public Runnable onTrailer(HeadersFrame frame) {
        HttpFields trailers = frame.getMetaData().getFields().asImmutable();
        try (AutoLock ignored = this.lock.lock();){
            this._demand = false;
            this._chunk = new Trailers(trailers);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Request #{}/{}, trailer:{}{}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), System.lineSeparator(), trailers});
        }
        return this._httpChannel.onContentAvailable();
    }

    private Content.Chunk createChunk(Stream.Data data) {
        DataFrame frame = data.frame();
        if (frame.isEndStream() && frame.remaining() == 0) {
            return Content.Chunk.EOF;
        }
        data.retain();
        return Content.Chunk.from((ByteBuffer)frame.getData(), (boolean)frame.isEndStream(), (Retainable)data);
    }

    public void prepareResponse(HttpFields.Mutable headers) {
    }

    public void send(MetaData.Request request, MetaData.Response response, boolean last, ByteBuffer byteBuffer, Callback callback) {
        ByteBuffer content;
        ByteBuffer byteBuffer2 = content = byteBuffer != null ? byteBuffer : BufferUtil.EMPTY_BUFFER;
        if (response != null) {
            this.sendHeaders(request, response, content, last, callback);
        } else {
            this.sendContent(request, content, last, callback);
        }
    }

    private void sendHeaders(MetaData.Request request, MetaData.Response response, ByteBuffer content, boolean last, Callback callback) {
        HeadersFrame headersFrame;
        this._responseMetaData = response;
        DataFrame dataFrame = null;
        HeadersFrame trailersFrame = null;
        boolean isHeadRequest = HttpMethod.HEAD.is(request.getMethod());
        boolean hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        int streamId = this._stream.getId();
        if (HttpStatus.isInterim((int)response.getStatus())) {
            if (hasContent) {
                callback.failed((Throwable)new IllegalStateException("Interim response cannot have content"));
                return;
            }
            if (this._expects100Continue && response.getStatus() == 100) {
                this._expects100Continue = false;
            }
            headersFrame = new HeadersFrame(streamId, (MetaData)response, null, false);
        } else {
            this.committed = true;
            if (last) {
                long realContentLength = BufferUtil.length((ByteBuffer)content);
                long contentLength = response.getContentLength();
                if (contentLength < 0L) {
                    this._responseMetaData = new MetaData.Response(response.getHttpVersion(), response.getStatus(), response.getReason(), response.getFields(), realContentLength, response.getTrailersSupplier());
                } else if (hasContent && contentLength != realContentLength) {
                    callback.failed((Throwable)new BadMessageException(500, String.format("Incorrect Content-Length %d!=%d", contentLength, realContentLength)));
                    return;
                }
            }
            if (hasContent) {
                headersFrame = new HeadersFrame(streamId, (MetaData)response, null, false);
                if (last) {
                    HttpFields trailers = this.retrieveTrailers();
                    if (trailers == null) {
                        dataFrame = new DataFrame(streamId, content, true);
                    } else {
                        dataFrame = new DataFrame(streamId, content, false);
                        trailersFrame = new HeadersFrame(streamId, new MetaData(HttpVersion.HTTP_2, trailers), null, true);
                    }
                } else {
                    dataFrame = new DataFrame(streamId, content, false);
                }
            } else if (last) {
                if (this.isTunnel(request, response)) {
                    headersFrame = new HeadersFrame(streamId, (MetaData)response, null, false);
                } else {
                    HttpFields trailers = this.retrieveTrailers();
                    if (trailers == null) {
                        headersFrame = new HeadersFrame(streamId, (MetaData)response, null, true);
                    } else {
                        headersFrame = new HeadersFrame(streamId, (MetaData)response, null, false);
                        trailersFrame = new HeadersFrame(streamId, new MetaData(HttpVersion.HTTP_2, trailers), null, true);
                    }
                }
            } else {
                headersFrame = new HeadersFrame(streamId, (MetaData)response, null, false);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}:{}{} {}{}{}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), System.lineSeparator(), HttpVersion.HTTP_2, response.getStatus(), System.lineSeparator(), response.getFields()});
        }
        this._stream.send(new HTTP2Stream.FrameList(headersFrame, dataFrame, trailersFrame), callback);
    }

    private void sendContent(MetaData.Request request, ByteBuffer content, boolean last, Callback callback) {
        boolean hasContent;
        boolean isHeadRequest = HttpMethod.HEAD.is(request.getMethod());
        boolean bl = hasContent = BufferUtil.hasContent((ByteBuffer)content) && !isHeadRequest;
        if (hasContent || last && !this.isTunnel(request, this._responseMetaData)) {
            if (!hasContent) {
                content = BufferUtil.EMPTY_BUFFER;
            }
            if (last) {
                HttpFields trailers = this.retrieveTrailers();
                if (trailers == null) {
                    this.sendDataFrame(content, true, true, callback);
                } else if (hasContent) {
                    SendTrailers sendTrailers = new SendTrailers(callback, trailers);
                    this.sendDataFrame(content, true, false, (Callback)sendTrailers);
                } else {
                    this.sendTrailersFrame(new MetaData(HttpVersion.HTTP_2, trailers), callback);
                }
            } else {
                this.sendDataFrame(content, false, false, callback);
            }
        } else {
            callback.succeeded();
        }
    }

    private HttpFields retrieveTrailers() {
        Supplier supplier = this._responseMetaData.getTrailersSupplier();
        if (supplier == null) {
            return null;
        }
        HttpFields trailers = (HttpFields)supplier.get();
        if (trailers == null) {
            return null;
        }
        return trailers.size() == 0 ? null : trailers;
    }

    private boolean isTunnel(MetaData.Request request, MetaData.Response response) {
        return MetaData.isTunnel((String)request.getMethod(), (int)response.getStatus());
    }

    public void push(final MetaData.Request resource) {
        if (!this._stream.getSession().isPushEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP/2 push disabled for {}", (Object)resource);
            }
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP/2 push {}", (Object)resource);
        }
        this._stream.push(new PushPromiseFrame(this._stream.getId(), resource), (Promise)new Promise<Stream>(){

            public void succeeded(Stream pushStream) {
                HttpStreamOverHTTP2.this._connection.push((HTTP2Stream)pushStream, resource);
            }

            public void failed(Throwable x) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Could not HTTP/2 push {}", (Object)resource, (Object)x);
                }
            }
        }, null);
    }

    public Runnable onPushRequest(MetaData.Request request) {
        try {
            this._requestMetaData = request;
            Runnable task = this._httpChannel.onRequest(request);
            this._httpChannel.getRequest().setAttribute("org.eclipse.jetty.pushed", (Object)Boolean.TRUE);
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP/2 push request #{}/{}:{}{} {} {}{}{}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), System.lineSeparator(), request.getMethod(), request.getURI(), request.getHttpVersion(), System.lineSeparator(), request.getFields()});
            }
            return task;
        }
        catch (BadMessageException x) {
            return () -> this.onBadMessage(x);
        }
        catch (Throwable x) {
            return () -> this.onBadMessage(new BadMessageException(500, null, x));
        }
    }

    private void sendDataFrame(ByteBuffer content, boolean lastContent, boolean endStream, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}: {} content bytes{}", new Object[]{this._stream.getId(), Integer.toHexString(this._stream.getSession().hashCode()), content.remaining(), lastContent ? " (last chunk)" : ""});
        }
        DataFrame frame = new DataFrame(this._stream.getId(), content, endStream);
        this._stream.data(frame, callback);
    }

    private void sendTrailersFrame(MetaData metaData, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 Response #{}/{}: trailers", (Object)this._stream.getId(), (Object)Integer.toHexString(this._stream.getSession().hashCode()));
        }
        HeadersFrame frame = new HeadersFrame(this._stream.getId(), metaData, null, true);
        this._stream.headers(frame, callback);
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isIdle() {
        return false;
    }

    public TunnelSupport getTunnelSupport() {
        return this.tunnelSupport;
    }

    public Throwable consumeAvailable() {
        if (HttpMethod.CONNECT.is(this._requestMetaData.getMethod())) {
            return null;
        }
        return super.consumeAvailable();
    }

    public void onTimeout(Throwable failure, BiConsumer<Runnable, Boolean> consumer) {
        Runnable task = this._httpChannel.onFailure(failure);
        boolean idle = !this._httpChannel.isRequestHandled();
        consumer.accept(task, idle);
    }

    public Runnable onFailure(Throwable failure, Callback callback) {
        Runnable runnable = this._httpChannel.onFailure(failure);
        return () -> {
            if (runnable != null) {
                runnable.run();
            }
            callback.succeeded();
        };
    }

    public void succeeded() {
        if (!this._stream.isClosed()) {
            if (this.isTunnel(this._requestMetaData, this._responseMetaData)) {
                Connection connection = (Connection)this._httpChannel.getRequest().getAttribute(HttpStream.UPGRADE_CONNECTION_ATTRIBUTE);
                if (connection == null) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("HTTP2 response #{}/{}: no upgrade connection, resetting stream", (Object)this._stream.getId(), (Object)Integer.toHexString(this._stream.getSession().hashCode()));
                    }
                    this._stream.reset(new ResetFrame(this._stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
                } else {
                    EndPoint endPoint = this.tunnelSupport.getEndPoint();
                    this._stream.setAttachment((Object)endPoint);
                    endPoint.upgrade(connection);
                }
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("HTTP2 response #{}/{}: unconsumed request content, resetting stream", (Object)this._stream.getId(), (Object)Integer.toHexString(this._stream.getSession().hashCode()));
                }
                this._stream.reset(new ResetFrame(this._stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
            }
        }
        this._httpChannel.recycle();
    }

    public void failed(Throwable x) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 response #{}/{} aborted", (Object)this._stream.getId(), (Object)Integer.toHexString(this._stream.getSession().hashCode()));
        }
        this._stream.reset(new ResetFrame(this._stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
    }

    private class TunnelSupportOverHTTP2
    implements TunnelSupport {
        private final String protocol;
        private final EndPoint endPoint;

        private TunnelSupportOverHTTP2(String protocol) {
            this.endPoint = new ServerHTTP2StreamEndPoint(HttpStreamOverHTTP2.this._stream);
            this.protocol = protocol;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public EndPoint getEndPoint() {
            return this.endPoint;
        }
    }

    private class SendTrailers
    extends Callback.Nested {
        private final HttpFields trailers;

        private SendTrailers(Callback callback, HttpFields trailers) {
            super(callback);
            this.trailers = trailers;
        }

        public void succeeded() {
            HttpStreamOverHTTP2.this.sendTrailersFrame(new MetaData(HttpVersion.HTTP_2, this.trailers), this.getCallback());
        }
    }
}

