/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.nio.ByteBuffer;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.Callback;

public class ByteBufferCallback
implements Callback {
    private final ByteBufferPool byteBufferPool;
    private final ByteBuffer buffer;
    private final Callback callback;

    public ByteBufferCallback(ByteBufferPool byteBufferPool, ByteBuffer buffer, Callback callback) {
        this.byteBufferPool = byteBufferPool;
        this.buffer = buffer;
        this.callback = callback;
    }

    public boolean isNonBlocking() {
        return this.callback.isNonBlocking();
    }

    public ByteBuffer getByteBuffer() {
        return this.buffer;
    }

    public void succeeded() {
        this.recycle();
        this.callback.succeeded();
    }

    public void failed(Throwable x) {
        this.recycle();
        this.callback.failed(x);
    }

    private void recycle() {
        this.byteBufferPool.release(this.buffer);
    }
}

