/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Cipher;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.server.AbstractHTTP2ServerConnectionFactory;
import org.eclipse.jetty.http2.server.HTTP2ServerConnection;
import org.eclipse.jetty.http2.server.HttpChannelOverHTTP2;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.NegotiatingServerConnection;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.annotation.Name;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HTTP2ServerConnectionFactory
extends AbstractHTTP2ServerConnectionFactory
implements NegotiatingServerConnection.CipherDiscriminator {
    private static final Logger LOG = Log.getLogger(HTTP2ServerConnectionFactory.class);

    public HTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration) {
        super(httpConfiguration);
    }

    protected HTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration, String ... protocols) {
        super(httpConfiguration, protocols);
    }

    @Override
    protected ServerSessionListener newSessionListener(Connector connector, EndPoint endPoint) {
        return new HTTPServerSessionListener(connector, endPoint);
    }

    public boolean isAcceptable(String protocol, String tlsProtocol, String tlsCipher) {
        return !HTTP2Cipher.isBlackListProtocol((String)tlsProtocol) || !HTTP2Cipher.isBlackListCipher((String)tlsCipher);
    }

    private class HTTPServerSessionListener
    extends ServerSessionListener.Adapter
    implements Stream.Listener {
        private final Connector connector;
        private final EndPoint endPoint;

        public HTTPServerSessionListener(Connector connector, EndPoint endPoint) {
            this.connector = connector;
            this.endPoint = endPoint;
        }

        public Map<Integer, Integer> onPreface(Session session) {
            HashMap<Integer, Integer> settings = new HashMap<Integer, Integer>();
            settings.put(1, HTTP2ServerConnectionFactory.this.getMaxDynamicTableSize());
            settings.put(4, HTTP2ServerConnectionFactory.this.getInitialStreamSendWindow());
            int maxConcurrentStreams = HTTP2ServerConnectionFactory.this.getMaxConcurrentStreams();
            if (maxConcurrentStreams >= 0) {
                settings.put(3, maxConcurrentStreams);
            }
            return settings;
        }

        public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
            ((HTTP2ServerConnection)this.endPoint.getConnection()).onNewStream(this.connector, (IStream)stream, frame);
            return frame.isEndStream() ? null : this;
        }

        public void onHeaders(Stream stream, HeadersFrame frame) {
            this.close(stream, "response_headers");
        }

        public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
            this.close(stream, "push_promise");
            return null;
        }

        public void onData(Stream stream, DataFrame frame, Callback callback) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Processing {} on {}", new Object[]{frame, stream});
            }
            HttpChannelOverHTTP2 channel = (HttpChannelOverHTTP2)((Object)stream.getAttribute(IStream.CHANNEL_ATTRIBUTE));
            channel.requestContent(frame, callback);
        }

        public void onReset(Stream stream, ResetFrame frame) {
        }

        public void onTimeout(Stream stream, Throwable x) {
        }

        private void close(Stream stream, String reason) {
            Session session = stream.getSession();
            session.close(ErrorCode.PROTOCOL_ERROR.code, reason, (Callback)Callback.Adapter.INSTANCE);
        }
    }
}

