/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.util.Objects;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.SimpleFlowControlStrategy;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.generator.Generator;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.http2.parser.ServerParser;
import org.eclipse.jetty.http2.server.HTTP2ServerConnection;
import org.eclipse.jetty.http2.server.HTTP2ServerSession;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.annotation.Name;

public abstract class AbstractHTTP2ServerConnectionFactory
extends AbstractConnectionFactory {
    private int maxDynamicTableSize = 4096;
    private int initialStreamSendWindow = 65535;
    private int maxConcurrentStreams = -1;
    private final HttpConfiguration httpConfiguration;

    public AbstractHTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration) {
        this(httpConfiguration, "h2-17", "h2-16", "h2-15", "h2-14", "h2");
    }

    protected AbstractHTTP2ServerConnectionFactory(@Name(value="config") HttpConfiguration httpConfiguration, String ... protocols) {
        super(protocols);
        this.httpConfiguration = Objects.requireNonNull(httpConfiguration);
    }

    public int getMaxDynamicTableSize() {
        return this.maxDynamicTableSize;
    }

    public void setMaxDynamicTableSize(int maxDynamicTableSize) {
        this.maxDynamicTableSize = maxDynamicTableSize;
    }

    public int getInitialStreamSendWindow() {
        return this.initialStreamSendWindow;
    }

    public void setInitialStreamSendWindow(int initialStreamSendWindow) {
        this.initialStreamSendWindow = initialStreamSendWindow;
    }

    public int getMaxConcurrentStreams() {
        return this.maxConcurrentStreams;
    }

    public void setMaxConcurrentStreams(int maxConcurrentStreams) {
        this.maxConcurrentStreams = maxConcurrentStreams;
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfiguration;
    }

    public Connection newConnection(Connector connector, EndPoint endPoint) {
        ServerSessionListener listener = this.newSessionListener(connector, endPoint);
        Generator generator = new Generator(connector.getByteBufferPool(), this.getMaxDynamicTableSize());
        FlowControlStrategy flowControl = this.newFlowControlStrategy();
        HTTP2ServerSession session = new HTTP2ServerSession(connector.getScheduler(), endPoint, generator, listener, flowControl);
        session.setMaxLocalStreams(this.getMaxConcurrentStreams());
        session.setMaxRemoteStreams(this.getMaxConcurrentStreams());
        session.setStreamIdleTimeout(endPoint.getIdleTimeout());
        ServerParser parser = this.newServerParser(connector, session);
        HTTP2ServerConnection connection = new HTTP2ServerConnection(connector.getByteBufferPool(), connector.getExecutor(), endPoint, this.httpConfiguration, (Parser)parser, (ISession)session, this.getInputBufferSize(), listener);
        return this.configure((AbstractConnection)connection, connector, endPoint);
    }

    protected FlowControlStrategy newFlowControlStrategy() {
        return new SimpleFlowControlStrategy(this.getInitialStreamSendWindow());
    }

    protected abstract ServerSessionListener newSessionListener(Connector var1, EndPoint var2);

    protected ServerParser newServerParser(Connector connector, ServerParser.Listener listener) {
        return new ServerParser(connector.getByteBufferPool(), listener, this.getMaxDynamicTableSize(), this.getHttpConfiguration().getRequestHeaderSize());
    }
}

