/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.util.Map;
import java.util.Objects;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.frames.GoAwayFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PingFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.server.AbstractHTTP2ServerConnectionFactory;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;

public class RawHTTP2ServerConnectionFactory
extends AbstractHTTP2ServerConnectionFactory {
    private final ServerSessionListener listener;

    public RawHTTP2ServerConnectionFactory(ServerSessionListener listener) {
        this(new HttpConfiguration(), listener);
    }

    public RawHTTP2ServerConnectionFactory(HttpConfiguration httpConfiguration, ServerSessionListener listener) {
        super(httpConfiguration);
        this.listener = new RawServerSessionListener(Objects.requireNonNull(listener));
    }

    public RawHTTP2ServerConnectionFactory(HttpConfiguration httpConfiguration, ServerSessionListener listener, String ... protocols) {
        super(httpConfiguration, protocols);
        this.listener = listener;
    }

    @Override
    protected ServerSessionListener newSessionListener(Connector connector, EndPoint endPoint) {
        return this.listener;
    }

    private class RawServerSessionListener
    implements ServerSessionListener {
        private final ServerSessionListener delegate;

        private RawServerSessionListener(ServerSessionListener delegate) {
            this.delegate = delegate;
        }

        public void onAccept(Session session) {
            this.delegate.onAccept(session);
        }

        public Map<Integer, Integer> onPreface(Session session) {
            Map<Integer, Integer> settings = RawHTTP2ServerConnectionFactory.this.newSettings();
            Map moreSettings = this.delegate.onPreface(session);
            if (moreSettings != null) {
                settings.putAll(moreSettings);
            }
            return settings;
        }

        public Stream.Listener onNewStream(Stream stream, HeadersFrame frame) {
            return this.delegate.onNewStream(stream, frame);
        }

        public void onSettings(Session session, SettingsFrame frame) {
            this.delegate.onSettings(session, frame);
        }

        public void onPing(Session session, PingFrame frame) {
            this.delegate.onPing(session, frame);
        }

        public void onReset(Session session, ResetFrame frame) {
            this.delegate.onReset(session, frame);
        }

        public void onClose(Session session, GoAwayFrame frame) {
            this.delegate.onClose(session, frame);
        }

        public boolean onIdleTimeout(Session session) {
            return this.delegate.onIdleTimeout(session);
        }

        public void onFailure(Session session, Throwable failure) {
            this.delegate.onFailure(session, failure);
        }
    }
}

