/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.util.function.Consumer;
import org.eclipse.jetty.http2.HTTP2Channel;
import org.eclipse.jetty.http2.HTTP2StreamEndPoint;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class ServerHTTP2StreamEndPoint
extends HTTP2StreamEndPoint
implements HTTP2Channel.Server {
    private static final Logger LOG = Log.getLogger(ServerHTTP2StreamEndPoint.class);

    public ServerHTTP2StreamEndPoint(IStream stream) {
        super(stream);
    }

    public Runnable onData(DataFrame frame, Callback callback) {
        this.offerData(frame, callback);
        return null;
    }

    public Runnable onTrailer(HeadersFrame frame) {
        return null;
    }

    public boolean onTimeout(Throwable failure, Consumer<Runnable> consumer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("idle timeout on {}: {}", new Object[]{this, failure});
        }
        this.offerFailure(failure);
        boolean result = true;
        Connection connection = this.getConnection();
        if (connection != null) {
            result = connection.onIdleExpired();
        }
        consumer.accept(() -> this.close(failure));
        return result;
    }

    public Runnable onFailure(Throwable failure, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failure on {}: {}", new Object[]{this, failure});
        }
        this.offerFailure(failure);
        this.close(failure);
        return () -> ((Callback)callback).succeeded();
    }

    public boolean isIdle() {
        return false;
    }
}

