/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.nio.channels.AsynchronousCloseException;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.SendFailure;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ConcurrentHashSet;
import org.eclipse.jetty.util.thread.Sweeper;

public class HttpConnectionOverHTTP2
extends HttpConnection
implements Sweeper.Sweepable {
    private final Set<HttpChannel> channels = new ConcurrentHashSet();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicInteger sweeps = new AtomicInteger();
    private final Session session;

    public HttpConnectionOverHTTP2(HttpDestination destination, Session session) {
        super(destination);
        this.session = session;
    }

    public Session getSession() {
        return this.session;
    }

    protected SendFailure send(HttpExchange exchange) {
        exchange.getRequest().version(HttpVersion.HTTP_2);
        this.normalizeRequest((Request)exchange.getRequest());
        HttpChannelOverHTTP2 channel = this.newHttpChannel(false);
        this.channels.add(channel);
        return this.send(channel, exchange);
    }

    protected HttpChannelOverHTTP2 newHttpChannel(boolean push) {
        return new HttpChannelOverHTTP2(this.getHttpDestination(), this, this.getSession(), push);
    }

    protected void release(HttpChannel channel) {
        this.channels.remove(channel);
        this.getHttpDestination().release((Connection)this);
    }

    public boolean onIdleTimeout(long idleTimeout) {
        boolean close = super.onIdleTimeout(idleTimeout);
        if (close) {
            this.close(new TimeoutException("idle_timeout"));
        }
        return false;
    }

    public void close() {
        this.close(new AsynchronousCloseException());
    }

    protected void close(Throwable failure) {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().close((Connection)this);
            this.abort(failure);
            this.session.close(ErrorCode.NO_ERROR.code, failure.getMessage(), Callback.NOOP);
        }
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    private void abort(Throwable failure) {
        for (HttpChannel channel : this.channels) {
            HttpExchange exchange = channel.getHttpExchange();
            if (exchange == null) continue;
            exchange.getRequest().abort(failure);
        }
        this.channels.clear();
    }

    public boolean sweep() {
        if (!this.isClosed()) {
            return false;
        }
        return this.sweeps.incrementAndGet() >= 4;
    }

    public String toString() {
        return String.format("%s@%x(closed=%b)[%s]", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.isClosed(), this.session);
    }
}

