/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Locale;
import java.util.Queue;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IteratingCallback;

public class HttpReceiverOverHTTP2
extends HttpReceiver
implements Stream.Listener {
    private final ContentNotifier contentNotifier = new ContentNotifier();

    public HttpReceiverOverHTTP2(HttpChannel channel) {
        super(channel);
    }

    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    public void onHeaders(Stream stream, HeadersFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        HttpResponse response = exchange.getResponse();
        MetaData.Response metaData = (MetaData.Response)frame.getMetaData();
        response.version(metaData.getVersion()).status(metaData.getStatus()).reason(metaData.getReason());
        if (this.responseBegin(exchange)) {
            HttpFields headers = metaData.getFields();
            for (HttpField header : headers) {
                if (this.responseHeader(exchange, header)) continue;
                return;
            }
            if (this.responseHeaders(exchange) && frame.isEndStream()) {
                this.responseSuccess(exchange);
            }
        }
    }

    public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
        stream.reset(new ResetFrame(stream.getId(), ErrorCode.REFUSED_STREAM_ERROR.code), Callback.NOOP);
        return null;
    }

    public void onData(Stream stream, DataFrame frame, Callback callback) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            callback.failed((Throwable)new IOException("terminated"));
            return;
        }
        ByteBufferPool byteBufferPool = this.getHttpDestination().getHttpClient().getByteBufferPool();
        ByteBuffer original = frame.getData();
        int length = original.remaining();
        ByteBuffer copy = byteBufferPool.acquire(length, original.isDirect());
        BufferUtil.clearToFill((ByteBuffer)copy);
        copy.put(original);
        BufferUtil.flipToFlush((ByteBuffer)copy, (int)0);
        this.contentNotifier.offer(new DataInfo(exchange, copy, callback, frame.isEndStream()));
        this.contentNotifier.iterate();
    }

    public void onReset(Stream stream, ResetFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        ErrorCode error = ErrorCode.from((int)frame.getError());
        String reason = error == null ? "reset" : error.name().toLowerCase(Locale.ENGLISH);
        exchange.getRequest().abort((Throwable)new IOException(reason));
    }

    public boolean onIdleTimeout(Stream stream, Throwable x) {
        this.responseFailure(x);
        return true;
    }

    private static class DataInfo {
        private final HttpExchange exchange;
        private final ByteBuffer buffer;
        private final Callback callback;
        private final boolean last;

        private DataInfo(HttpExchange exchange, ByteBuffer buffer, Callback callback, boolean last) {
            this.exchange = exchange;
            this.buffer = buffer;
            this.callback = callback;
            this.last = last;
        }
    }

    private class ContentNotifier
    extends IteratingCallback {
        private final Queue<DataInfo> queue = new ArrayDeque<DataInfo>();
        private DataInfo dataInfo;

        private ContentNotifier() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean offer(DataInfo dataInfo) {
            ContentNotifier contentNotifier = this;
            synchronized (contentNotifier) {
                return this.queue.offer(dataInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IteratingCallback.Action process() throws Exception {
            DataInfo dataInfo;
            ContentNotifier contentNotifier = this;
            synchronized (contentNotifier) {
                dataInfo = this.queue.poll();
            }
            if (dataInfo == null) {
                return IteratingCallback.Action.IDLE;
            }
            this.dataInfo = dataInfo;
            HttpReceiverOverHTTP2.this.responseContent(dataInfo.exchange, dataInfo.buffer, (Callback)this);
            return IteratingCallback.Action.SCHEDULED;
        }

        public void succeeded() {
            ByteBufferPool byteBufferPool = HttpReceiverOverHTTP2.this.getHttpDestination().getHttpClient().getByteBufferPool();
            byteBufferPool.release(this.dataInfo.buffer);
            this.dataInfo.callback.succeeded();
            if (this.dataInfo.last) {
                HttpReceiverOverHTTP2.this.responseSuccess(this.dataInfo.exchange);
            }
            super.succeeded();
        }

        protected void onCompleteFailure(Throwable failure) {
            ByteBufferPool byteBufferPool = HttpReceiverOverHTTP2.this.getHttpDestination().getHttpClient().getByteBufferPool();
            byteBufferPool.release(this.dataInfo.buffer);
            this.dataInfo.callback.failed(failure);
            HttpReceiverOverHTTP2.this.responseFailure(failure);
        }
    }
}

