/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import org.eclipse.jetty.alpn.client.ALPNClientConnectionFactory;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.HTTP2ClientConnectionFactory;
import org.eclipse.jetty.http2.client.http.HttpConnectionOverHTTP2;
import org.eclipse.jetty.http2.client.http.HttpDestinationOverHTTP2;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;

@ManagedObject(value="The HTTP/2 client transport")
public class HttpClientTransportOverHTTP2
extends ContainerLifeCycle
implements HttpClientTransport {
    private final HTTP2Client client;
    private ClientConnectionFactory connectionFactory;
    private HttpClient httpClient;

    public HttpClientTransportOverHTTP2(HTTP2Client client) {
        this.client = client;
    }

    @ManagedAttribute(value="The number of selectors", readonly=true)
    public int getSelectors() {
        return this.client.getSelectors();
    }

    protected void doStart() throws Exception {
        if (!this.client.isStarted()) {
            this.client.setExecutor(this.httpClient.getExecutor());
            this.client.setScheduler(this.httpClient.getScheduler());
            this.client.setByteBufferPool(this.httpClient.getByteBufferPool());
            this.client.setConnectTimeout(this.httpClient.getConnectTimeout());
            this.client.setIdleTimeout(this.httpClient.getIdleTimeout());
        }
        this.addBean(this.client);
        super.doStart();
        this.connectionFactory = new HTTP2ClientConnectionFactory();
        this.client.setClientConnectionFactory((endPoint, context) -> {
            HttpDestination destination = (HttpDestination)context.get("http.destination");
            return destination.getClientConnectionFactory().newConnection(endPoint, context);
        });
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.client);
    }

    public void setHttpClient(HttpClient client) {
        this.httpClient = client;
    }

    public HttpDestination newHttpDestination(Origin origin) {
        return new HttpDestinationOverHTTP2(this.httpClient, origin);
    }

    public void connect(InetSocketAddress address, Map<String, Object> context) {
        this.client.setConnectTimeout(this.httpClient.getConnectTimeout());
        final HttpDestination destination = (HttpDestination)context.get("http.destination");
        final Promise connection = (Promise)context.get("http.connection.promise");
        Session.Listener.Adapter listener = new Session.Listener.Adapter(){

            public void onFailure(Session session, Throwable failure) {
                destination.abort(failure);
            }
        };
        Promise<Session> promise = new Promise<Session>(){

            public void succeeded(Session session) {
                connection.succeeded((Object)HttpClientTransportOverHTTP2.this.newHttpConnection(destination, session));
            }

            public void failed(Throwable failure) {
                connection.failed(failure);
            }
        };
        SslContextFactory sslContextFactory = null;
        if (HttpScheme.HTTPS.is(destination.getScheme())) {
            sslContextFactory = this.httpClient.getSslContextFactory();
        }
        this.client.connect(sslContextFactory, address, (Session.Listener)listener, (Promise)promise, context);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        ClientConnectionFactory factory = this.connectionFactory;
        SslContextFactory sslContextFactory = (SslContextFactory)context.get("ssl.context.factory");
        if (sslContextFactory != null) {
            factory = new ALPNClientConnectionFactory(this.client.getExecutor(), factory, this.client.getProtocols());
        }
        return factory.newConnection(endPoint, context);
    }

    protected HttpConnectionOverHTTP2 newHttpConnection(HttpDestination destination, Session session) {
        return new HttpConnectionOverHTTP2(destination, session);
    }
}

