/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.io.IOException;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.util.Callback;

public class HttpReceiverOverHTTP2
extends HttpReceiver
implements Stream.Listener {
    public HttpReceiverOverHTTP2(HttpChannel channel) {
        super(channel);
    }

    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    public void onHeaders(Stream stream, HeadersFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        HttpResponse response = exchange.getResponse();
        MetaData.Response metaData = (MetaData.Response)frame.getMetaData();
        response.version(metaData.getVersion()).status(metaData.getStatus()).reason(metaData.getReason());
        if (this.responseBegin(exchange)) {
            HttpFields headers = metaData.getFields();
            for (HttpField header : headers) {
                if (this.responseHeader(exchange, header)) continue;
                return;
            }
            if (this.responseHeaders(exchange) && frame.isEndStream()) {
                this.responseSuccess(exchange);
            }
        }
    }

    public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
        stream.reset(new ResetFrame(stream.getId(), ErrorCode.REFUSED_STREAM_ERROR.code), (Callback)Callback.Adapter.INSTANCE);
        return null;
    }

    public void onData(Stream stream, DataFrame frame, Callback callback) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        if (this.responseContent(exchange, frame.getData(), callback) && frame.isEndStream()) {
            this.responseSuccess(exchange);
        }
    }

    public void onReset(Stream stream, ResetFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        ErrorCode error = ErrorCode.from((int)frame.getError());
        String reason = error == null ? "reset" : error.name().toLowerCase();
        exchange.getRequest().abort((Throwable)new IOException(reason));
    }

    public void onTimeout(Stream stream, Throwable failure) {
        this.responseFailure(failure);
    }
}

