/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.net.URI;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSenderOverHTTP2
extends HttpSender {
    private static final Logger LOG = LoggerFactory.getLogger(HttpSenderOverHTTP2.class);

    public HttpSenderOverHTTP2(HttpChannelOverHTTP2 channel) {
        super((HttpChannel)channel);
    }

    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    protected void sendHeaders(HttpExchange exchange, ByteBuffer contentBuffer, boolean lastContent, Callback callback) {
        HeadersPromise promise;
        HeadersFrame headersFrame;
        MetaData.ConnectRequest metaData;
        HttpRequest request = exchange.getRequest();
        boolean isTunnel = HttpMethod.CONNECT.is(request.getMethod());
        if (isTunnel) {
            String upgradeProtocol = request.getUpgradeProtocol();
            if (upgradeProtocol == null) {
                metaData = new MetaData.ConnectRequest((String)null, new HostPortHttpField(request.getPath()), null, (HttpFields)request.getHeaders(), null);
            } else {
                HostPortHttpField authority = new HostPortHttpField(request.getHost(), request.getPort());
                metaData = new MetaData.ConnectRequest(request.getScheme(), authority, request.getPath(), (HttpFields)request.getHeaders(), upgradeProtocol);
            }
        } else {
            String path = this.relativize(request.getPath());
            HttpURI.Mutable uri = HttpURI.build().scheme(request.getScheme()).host(request.getHost()).port(request.getPort()).path(path).query(request.getQuery());
            metaData = new MetaData.Request(request.getMethod(), (HttpURI)uri, HttpVersion.HTTP_2, (HttpFields)request.getHeaders(), -1L, request.getTrailers());
        }
        if (isTunnel) {
            headersFrame = new HeadersFrame((MetaData)metaData, null, false);
            promise = new HeadersPromise(request, callback, stream -> callback.succeeded());
        } else {
            Supplier trailerSupplier = request.getTrailers();
            if (BufferUtil.isEmpty((ByteBuffer)contentBuffer) && lastContent) {
                HttpFields trailers = trailerSupplier == null ? null : (HttpFields)trailerSupplier.get();
                boolean endStream = trailers == null || trailers.size() == 0;
                headersFrame = new HeadersFrame((MetaData)metaData, null, endStream);
                promise = new HeadersPromise(request, callback, stream -> {
                    if (endStream) {
                        callback.succeeded();
                    } else {
                        this.sendTrailers((Stream)stream, trailers, callback);
                    }
                });
            } else {
                headersFrame = new HeadersFrame((MetaData)metaData, null, false);
                promise = new HeadersPromise(request, callback, arg_0 -> this.lambda$sendHeaders$2(contentBuffer, lastContent, (Supplier)trailerSupplier, callback, arg_0));
            }
        }
        HttpChannelOverHTTP2 channel = this.getHttpChannel();
        channel.getSession().newStream(headersFrame, (Promise)promise, channel.getStreamListener());
    }

    private String relativize(String path) {
        try {
            String result = path;
            URI uri = URI.create(result);
            if (uri.isAbsolute()) {
                result = uri.getPath();
            }
            return result.isEmpty() ? "/" : result;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not relativize " + path);
            }
            return path;
        }
    }

    protected void sendContent(HttpExchange exchange, ByteBuffer contentBuffer, boolean lastContent, Callback callback) {
        Stream stream = this.getHttpChannel().getStream();
        Supplier trailerSupplier = exchange.getRequest().getTrailers();
        this.sendContent(stream, contentBuffer, lastContent, trailerSupplier, callback);
    }

    private void sendContent(Stream stream, ByteBuffer buffer, boolean lastContent, Supplier<HttpFields> trailerSupplier, Callback callback) {
        boolean hasContent = buffer.hasRemaining();
        if (lastContent) {
            boolean hasTrailers;
            HttpFields trailers = trailerSupplier == null ? null : trailerSupplier.get();
            boolean bl = hasTrailers = trailers != null && trailers.size() > 0;
            if (hasContent) {
                DataFrame dataFrame = new DataFrame(stream.getId(), buffer, !hasTrailers);
                Callback dataCallback = callback;
                if (hasTrailers) {
                    dataCallback = Callback.from(() -> this.sendTrailers(stream, trailers, callback), arg_0 -> ((Callback)callback).failed(arg_0));
                }
                stream.data(dataFrame, dataCallback);
            } else if (hasTrailers) {
                this.sendTrailers(stream, trailers, callback);
            } else {
                DataFrame dataFrame = new DataFrame(stream.getId(), buffer, true);
                stream.data(dataFrame, callback);
            }
        } else if (hasContent) {
            DataFrame dataFrame = new DataFrame(stream.getId(), buffer, false);
            stream.data(dataFrame, callback);
        } else {
            callback.succeeded();
        }
    }

    private void sendTrailers(Stream stream, HttpFields trailers, Callback callback) {
        MetaData metaData = new MetaData(HttpVersion.HTTP_2, trailers);
        HeadersFrame trailersFrame = new HeadersFrame(stream.getId(), metaData, null, true);
        stream.headers(trailersFrame, callback);
    }

    private /* synthetic */ void lambda$sendHeaders$2(ByteBuffer contentBuffer, boolean lastContent, Supplier trailerSupplier, Callback callback, Stream stream) {
        this.sendContent(stream, contentBuffer, lastContent, trailerSupplier, callback);
    }

    private static class HeadersPromise
    implements Promise<Stream> {
        private final HttpRequest request;
        private final Callback callback;
        private final Consumer<Stream> succeed;

        private HeadersPromise(HttpRequest request, Callback callback, Consumer<Stream> succeed) {
            this.request = request;
            this.callback = callback;
            this.succeed = succeed;
        }

        public void succeeded(Stream stream) {
            long idleTimeout = this.request.getIdleTimeout();
            if (idleTimeout >= 0L) {
                stream.setIdleTimeout(idleTimeout);
            }
            this.succeed.accept(stream);
        }

        public void failed(Throwable x) {
            this.callback.failed(x);
        }
    }
}

