/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.api.Result;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Channel;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.HttpConnectionOverHTTP2;
import org.eclipse.jetty.http2.client.http.HttpReceiverOverHTTP2;
import org.eclipse.jetty.http2.client.http.HttpSenderOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.thread.Invocable;

public class HttpChannelOverHTTP2
extends HttpChannel {
    private final Stream.Listener listener = new Listener();
    private final HttpConnectionOverHTTP2 connection;
    private final Session session;
    private final HttpSenderOverHTTP2 sender;
    private final HttpReceiverOverHTTP2 receiver;
    private Stream stream;

    public HttpChannelOverHTTP2(HttpDestination destination, HttpConnectionOverHTTP2 connection, Session session) {
        super(destination);
        this.connection = connection;
        this.session = session;
        this.sender = new HttpSenderOverHTTP2(this);
        this.receiver = new HttpReceiverOverHTTP2(this);
    }

    protected HttpConnectionOverHTTP2 getHttpConnection() {
        return this.connection;
    }

    public Session getSession() {
        return this.session;
    }

    public Stream.Listener getStreamListener() {
        return this.listener;
    }

    protected HttpSender getHttpSender() {
        return this.sender;
    }

    protected HttpReceiver getHttpReceiver() {
        return this.receiver;
    }

    public Stream getStream() {
        return this.stream;
    }

    public void setStream(Stream stream) {
        this.stream = stream;
        if (stream != null) {
            ((IStream)stream).setAttachment((Object)this.receiver);
        }
    }

    public boolean isFailed() {
        return this.sender.isFailed() || this.receiver.isFailed();
    }

    public void send(HttpExchange exchange) {
        this.sender.send(exchange);
    }

    public void release() {
        this.connection.release(this);
    }

    void onStreamClosed(IStream stream) {
        this.connection.onStreamClosed(stream, this);
    }

    public void exchangeTerminated(HttpExchange exchange, Result result) {
        super.exchangeTerminated(exchange, result);
        if (result.isSucceeded()) {
            this.release();
        } else {
            Stream stream = this.getStream();
            if (stream != null) {
                stream.reset(new ResetFrame(stream.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), (Callback)new ReleaseCallback());
            } else {
                this.release();
            }
        }
    }

    public String toString() {
        return String.format("%s[send=%s,recv=%s]", new Object[]{super.toString(), this.sender, this.receiver});
    }

    private class Listener
    implements Stream.Listener {
        private Listener() {
        }

        public void onNewStream(Stream stream) {
            HttpChannelOverHTTP2.this.setStream(stream);
        }

        public void onHeaders(Stream stream, HeadersFrame frame) {
            HttpChannelOverHTTP2.this.receiver.onHeaders(stream, frame);
        }

        public Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
            return HttpChannelOverHTTP2.this.receiver.onPush(stream, frame);
        }

        public void onData(Stream stream, DataFrame frame, Callback callback) {
            HTTP2Channel.Client channel = (HTTP2Channel.Client)((IStream)stream).getAttachment();
            channel.onData(frame, callback);
        }

        public void onReset(Stream stream, ResetFrame frame) {
            HttpChannelOverHTTP2.this.receiver.onReset(stream, frame);
        }

        public boolean onIdleTimeout(Stream stream, Throwable x) {
            HTTP2Channel.Client channel = (HTTP2Channel.Client)((IStream)stream).getAttachment();
            return channel.onTimeout(x);
        }

        public void onFailure(Stream stream, int error, String reason, Throwable failure, Callback callback) {
            HTTP2Channel.Client channel = (HTTP2Channel.Client)((IStream)stream).getAttachment();
            channel.onFailure(failure, callback);
        }

        public void onClosed(Stream stream) {
            HttpChannelOverHTTP2.this.receiver.onClosed(stream);
        }
    }

    private class ReleaseCallback
    implements Callback {
        private ReleaseCallback() {
        }

        public void succeeded() {
            HttpChannelOverHTTP2.this.release();
        }

        public void failed(Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("ReleaseCallback failed", x);
            }
            HttpChannelOverHTTP2.this.release();
        }

        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    }
}

