/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.List;
import java.util.Queue;
import java.util.function.BiFunction;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpConversation;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpReceiver;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpResponse;
import org.eclipse.jetty.client.HttpUpgrader;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Channel;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.ClientHTTP2StreamEndPoint;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpReceiverOverHTTP2
extends HttpReceiver
implements HTTP2Channel.Client {
    private static final Logger LOG = LoggerFactory.getLogger(HttpReceiverOverHTTP2.class);
    private final ContentNotifier contentNotifier = new ContentNotifier(this);

    public HttpReceiverOverHTTP2(HttpChannel channel) {
        super(channel);
    }

    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    protected void receive() {
        this.contentNotifier.process(true);
    }

    protected void reset() {
        super.reset();
        this.contentNotifier.reset();
    }

    void onHeaders(Stream stream, HeadersFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        HttpResponse httpResponse = exchange.getResponse();
        MetaData metaData = frame.getMetaData();
        if (metaData.isResponse()) {
            MetaData.Response response = (MetaData.Response)frame.getMetaData();
            httpResponse.version(response.getHttpVersion()).status(response.getStatus()).reason(response.getReason());
            if (this.responseBegin(exchange)) {
                HttpFields headers = response.getFields();
                for (HttpField header : headers) {
                    if (this.responseHeader(exchange, header)) continue;
                    return;
                }
                HttpRequest httpRequest = exchange.getRequest();
                if (HttpMethod.CONNECT.is(httpRequest.getMethod()) && httpResponse.getStatus() == 200) {
                    ClientHTTP2StreamEndPoint endPoint = new ClientHTTP2StreamEndPoint((IStream)stream);
                    long idleTimeout = httpRequest.getIdleTimeout();
                    if (idleTimeout > 0L) {
                        endPoint.setIdleTimeout(idleTimeout);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Successful HTTP2 tunnel on {} via {}", (Object)stream, (Object)endPoint);
                    }
                    ((IStream)stream).setAttachment((Object)endPoint);
                    HttpConversation conversation = httpRequest.getConversation();
                    conversation.setAttribute(EndPoint.class.getName(), (Object)endPoint);
                    HttpUpgrader upgrader = (HttpUpgrader)conversation.getAttribute(HttpUpgrader.class.getName());
                    if (upgrader != null) {
                        this.upgrade(upgrader, httpResponse, (EndPoint)endPoint);
                    }
                }
                if (this.responseHeaders(exchange)) {
                    boolean informational;
                    int status = response.getStatus();
                    boolean bl = informational = HttpStatus.isInformational((int)status) && status != 101;
                    if (frame.isEndStream() || informational) {
                        this.responseSuccess(exchange);
                    }
                } else if (frame.isEndStream()) {
                    this.notifyContent(exchange, new DataFrame(stream.getId(), BufferUtil.EMPTY_BUFFER, true), Callback.NOOP);
                }
            }
        } else {
            HttpFields trailers = metaData.getFields();
            trailers.forEach(arg_0 -> ((HttpResponse)httpResponse).trailer(arg_0));
            this.notifyContent(exchange, new DataFrame(stream.getId(), BufferUtil.EMPTY_BUFFER, true), Callback.NOOP);
        }
    }

    private void upgrade(HttpUpgrader upgrader, HttpResponse response, EndPoint endPoint) {
        try {
            upgrader.upgrade(response, endPoint, Callback.from(() -> ((Callback)Callback.NOOP).succeeded(), arg_0 -> ((HttpReceiverOverHTTP2)this).responseFailure(arg_0)));
        }
        catch (Throwable x) {
            this.responseFailure(x);
        }
    }

    Stream.Listener onPush(Stream stream, PushPromiseFrame frame) {
        Response.CompleteListener listener;
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return null;
        }
        HttpRequest request = exchange.getRequest();
        MetaData.Request metaData = frame.getMetaData();
        HttpRequest pushRequest = (HttpRequest)this.getHttpDestination().getHttpClient().newRequest(metaData.getURIString());
        BiFunction pushListener = request.getPushListener();
        if (pushListener != null && (listener = (Response.CompleteListener)pushListener.apply(request, pushRequest)) != null) {
            HttpChannelOverHTTP2 pushChannel = this.getHttpChannel().getHttpConnection().acquireHttpChannel();
            HttpExchange pushExchange = new HttpExchange(this.getHttpDestination(), pushRequest, List.of(listener));
            pushChannel.associate(pushExchange);
            pushChannel.setStream(stream);
            pushExchange.requestComplete(null);
            pushExchange.terminateRequest();
            return pushChannel.getStreamListener();
        }
        stream.reset(new ResetFrame(stream.getId(), ErrorCode.REFUSED_STREAM_ERROR.code), Callback.NOOP);
        return null;
    }

    public void onData(DataFrame frame, Callback callback) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            callback.failed((Throwable)new IOException("terminated"));
        } else {
            this.notifyContent(exchange, frame, callback);
        }
    }

    void onReset(Stream stream, ResetFrame frame) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        int error = frame.getError();
        exchange.getRequest().abort((Throwable)new IOException(ErrorCode.toString((int)error, (String)("reset_code_" + error))));
    }

    public boolean onTimeout(Throwable failure) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return false;
        }
        return !exchange.abort(failure);
    }

    public void onFailure(Throwable failure, Callback callback) {
        this.responseFailure(failure);
        callback.succeeded();
    }

    void onClosed(Stream stream) {
        this.getHttpChannel().onStreamClosed((IStream)stream);
    }

    private void notifyContent(HttpExchange exchange, DataFrame frame, Callback callback) {
        this.contentNotifier.offer(exchange, frame, callback);
    }

    private class ContentNotifier {
        private final Queue<DataInfo> queue = new ArrayDeque<DataInfo>();
        private final HttpReceiverOverHTTP2 receiver;
        private DataInfo dataInfo;
        private boolean active;
        private boolean resume;
        private boolean stalled;

        private ContentNotifier(HttpReceiverOverHTTP2 receiver) {
            this.receiver = receiver;
        }

        private void offer(HttpExchange exchange, DataFrame frame, Callback callback) {
            DataInfo dataInfo = new DataInfo(exchange, frame, callback);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Queueing content {}", (Object)dataInfo);
            }
            this.enqueue(dataInfo);
            this.process(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enqueue(DataInfo dataInfo) {
            ContentNotifier contentNotifier = this;
            synchronized (contentNotifier) {
                this.queue.offer(dataInfo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process(boolean resume) {
            boolean busy = this.active(resume);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Resuming({}) processing({}) of content", (Object)resume, (Object)(!busy ? 1 : 0));
            }
            if (busy) {
                return;
            }
            ContentNotifier contentNotifier = this;
            synchronized (contentNotifier) {
                if (!resume && HttpReceiverOverHTTP2.this.demand() <= 0L) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Stalling processing, content available but no demand");
                    }
                    this.active = false;
                    this.stalled = true;
                    return;
                }
            }
            while (true) {
                if (this.dataInfo != null && this.dataInfo.frame.isEndStream()) {
                    this.receiver.responseSuccess(this.dataInfo.exchange);
                    return;
                }
                contentNotifier = this;
                synchronized (contentNotifier) {
                    this.dataInfo = this.queue.poll();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Processing content {}", (Object)this.dataInfo);
                    }
                    if (this.dataInfo == null) {
                        this.active = false;
                        return;
                    }
                }
                ByteBuffer buffer = this.dataInfo.frame.getData();
                Callback callback = this.dataInfo.callback;
                if (buffer.hasRemaining()) {
                    boolean proceed = this.receiver.responseContent(this.dataInfo.exchange, buffer, Callback.from(() -> ((Callback)callback).succeeded(), x -> this.fail(callback, (Throwable)x)));
                    if (proceed) continue;
                    boolean stall = this.stall();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Stalling({}) processing", (Object)stall);
                    }
                    if (!stall) continue;
                    return;
                }
                callback.succeeded();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean active(boolean resume) {
            ContentNotifier contentNotifier = this;
            synchronized (contentNotifier) {
                if (this.active) {
                    if (resume) {
                        this.resume = true;
                    }
                    return true;
                }
                if (this.stalled && !resume) {
                    return true;
                }
                this.active = true;
                this.stalled = false;
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean stall() {
            ContentNotifier contentNotifier = this;
            synchronized (contentNotifier) {
                if (this.resume) {
                    this.resume = false;
                    return false;
                }
                this.active = false;
                this.stalled = true;
                return true;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void reset() {
            this.dataInfo = null;
            ContentNotifier contentNotifier = this;
            synchronized (contentNotifier) {
                this.queue.clear();
                this.active = false;
                this.resume = false;
                this.stalled = false;
            }
        }

        private void fail(Callback callback, Throwable failure) {
            callback.failed(failure);
            this.receiver.responseFailure(failure);
        }

        private class DataInfo {
            private final HttpExchange exchange;
            private final DataFrame frame;
            private final Callback callback;

            private DataInfo(HttpExchange exchange, DataFrame frame, Callback callback) {
                this.exchange = exchange;
                this.frame = frame;
                this.callback = callback;
            }

            public String toString() {
                return String.format("%s@%x[%s]", this.getClass().getSimpleName(), this.hashCode(), this.frame);
            }
        }
    }
}

