/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.alpn.client.ALPNClientConnectionFactory;
import org.eclipse.jetty.client.AbstractHttpClientTransport;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.MultiplexConnectionPool;
import org.eclipse.jetty.client.MultiplexHttpDestination;
import org.eclipse.jetty.client.Origin;
import org.eclipse.jetty.client.ProxyConfiguration;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.HTTP2ClientConnectionFactory;
import org.eclipse.jetty.http2.client.http.HTTPSessionListenerPromise;
import org.eclipse.jetty.http2.client.http.HttpConnectionOverHTTP2;
import org.eclipse.jetty.http2.frames.GoAwayFrame;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.annotation.ManagedAttribute;
import org.eclipse.jetty.util.annotation.ManagedObject;

@ManagedObject(value="The HTTP/2 client transport")
public class HttpClientTransportOverHTTP2
extends AbstractHttpClientTransport {
    private final ClientConnectionFactory connectionFactory = new HTTP2ClientConnectionFactory();
    private final HTTP2Client client;
    private boolean useALPN = true;

    public HttpClientTransportOverHTTP2(HTTP2Client client) {
        this.client = client;
        this.addBean(client.getClientConnector(), false);
        this.setConnectionPoolFactory(destination -> {
            HttpClient httpClient = this.getHttpClient();
            return new MultiplexConnectionPool(destination, httpClient.getMaxConnectionsPerDestination(), (Callback)destination, httpClient.getMaxRequestsQueuedPerDestination());
        });
    }

    public HTTP2Client getHTTP2Client() {
        return this.client;
    }

    @ManagedAttribute(value="The number of selectors", readonly=true)
    public int getSelectors() {
        return this.client.getSelectors();
    }

    @ManagedAttribute(value="Whether ALPN should be used when establishing connections")
    public boolean isUseALPN() {
        return this.useALPN;
    }

    public void setUseALPN(boolean useALPN) {
        this.useALPN = useALPN;
    }

    protected void doStart() throws Exception {
        if (!this.client.isStarted()) {
            HttpClient httpClient = this.getHttpClient();
            this.client.setExecutor(httpClient.getExecutor());
            this.client.setScheduler(httpClient.getScheduler());
            this.client.setByteBufferPool(httpClient.getByteBufferPool());
            this.client.setConnectTimeout(httpClient.getConnectTimeout());
            this.client.setIdleTimeout(httpClient.getIdleTimeout());
            this.client.setInputBufferSize(httpClient.getResponseBufferSize());
            this.client.setUseInputDirectByteBuffers(httpClient.isUseInputDirectByteBuffers());
            this.client.setUseOutputDirectByteBuffers(httpClient.isUseOutputDirectByteBuffers());
        }
        this.addBean(this.client);
        super.doStart();
    }

    protected void doStop() throws Exception {
        super.doStop();
        this.removeBean(this.client);
    }

    public Origin newOrigin(HttpRequest request) {
        String protocol = HttpScheme.HTTPS.is(request.getScheme()) ? "h2" : "h2c";
        return this.getHttpClient().createOrigin(request, new Origin.Protocol(List.of(protocol), false));
    }

    public HttpDestination newHttpDestination(Origin origin) {
        return new MultiplexHttpDestination(this.getHttpClient(), origin);
    }

    public void connect(SocketAddress address, Map<String, Object> context) {
        HttpClient httpClient = this.getHttpClient();
        this.client.setConnectTimeout(httpClient.getConnectTimeout());
        this.client.setConnectBlocking(httpClient.isConnectBlocking());
        this.client.setBindAddress(httpClient.getBindAddress());
        SessionListenerPromise listenerPromise = new SessionListenerPromise(context);
        HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
        this.connect(address, destination.getClientConnectionFactory(), (Session.Listener)listenerPromise, (Promise<Session>)listenerPromise, context);
    }

    public void connect(InetSocketAddress address, Map<String, Object> context) {
        this.connect((SocketAddress)address, context);
    }

    protected void connect(SocketAddress address, ClientConnectionFactory factory, Session.Listener listener, Promise<Session> promise, Map<String, Object> context) {
        this.getHTTP2Client().connect(address, factory, listener, promise, context);
    }

    protected void connect(InetSocketAddress address, ClientConnectionFactory factory, Session.Listener listener, Promise<Session> promise, Map<String, Object> context) {
        this.connect((SocketAddress)address, factory, listener, promise, context);
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        boolean ssl;
        endPoint.setIdleTimeout(this.getHttpClient().getIdleTimeout());
        ClientConnectionFactory factory = this.connectionFactory;
        HttpDestination destination = (HttpDestination)context.get("org.eclipse.jetty.client.destination");
        ProxyConfiguration.Proxy proxy = destination.getProxy();
        boolean bl = ssl = proxy == null ? destination.isSecure() : proxy.isSecure();
        if (ssl && this.isUseALPN()) {
            factory = new ALPNClientConnectionFactory(this.client.getExecutor(), factory, this.client.getProtocols());
        }
        return factory.newConnection(endPoint, context);
    }

    protected HttpConnectionOverHTTP2 newHttpConnection(HttpDestination destination, Session session) {
        return new HttpConnectionOverHTTP2(destination, session);
    }

    protected void onClose(HttpConnectionOverHTTP2 connection, GoAwayFrame frame) {
        connection.close();
    }

    private class SessionListenerPromise
    extends HTTPSessionListenerPromise {
        private SessionListenerPromise(Map<String, Object> context) {
            super(context);
        }

        @Override
        protected HttpConnectionOverHTTP2 newHttpConnection(HttpDestination destination, Session session) {
            return HttpClientTransportOverHTTP2.this.newHttpConnection(destination, session);
        }

        @Override
        void onClose(HttpConnectionOverHTTP2 connection, GoAwayFrame frame) {
            HttpClientTransportOverHTTP2.this.onClose(connection, frame);
        }
    }
}

