/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.net.URI;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;

public class HttpSenderOverHTTP2
extends HttpSender {
    public HttpSenderOverHTTP2(HttpChannelOverHTTP2 channel) {
        super((HttpChannel)channel);
    }

    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    protected void sendHeaders(HttpExchange exchange, HttpContent content, Callback callback) {
        HeadersPromise promise;
        HeadersFrame headersFrame;
        MetaData.Request metaData;
        HttpRequest request = exchange.getRequest();
        boolean isTunnel = HttpMethod.CONNECT.is(request.getMethod());
        if (isTunnel) {
            metaData = new MetaData.Request(request.getMethod(), null, new HostPortHttpField(request.getPath()), null, HttpVersion.HTTP_2, request.getHeaders());
        } else {
            String path = this.relativize(request.getPath());
            HttpURI uri = HttpURI.createHttpURI((String)request.getScheme(), (String)request.getHost(), (int)request.getPort(), (String)path, null, (String)request.getQuery(), null);
            metaData = new MetaData.Request(request.getMethod(), uri, HttpVersion.HTTP_2, request.getHeaders());
        }
        Supplier trailerSupplier = request.getTrailers();
        metaData.setTrailerSupplier(trailerSupplier);
        if (isTunnel) {
            headersFrame = new HeadersFrame((MetaData)metaData, null, false);
            promise = new HeadersPromise(request, callback, stream -> callback.succeeded());
        } else if (content.hasContent()) {
            headersFrame = new HeadersFrame((MetaData)metaData, null, false);
            promise = new HeadersPromise(request, callback, arg_0 -> this.lambda$sendHeaders$1(request, callback, content, (Supplier)trailerSupplier, arg_0));
        } else {
            HttpFields trailers = trailerSupplier == null ? null : (HttpFields)trailerSupplier.get();
            boolean endStream = trailers == null || trailers.size() <= 0;
            headersFrame = new HeadersFrame((MetaData)metaData, null, endStream);
            promise = new HeadersPromise(request, callback, stream -> {
                if (endStream) {
                    callback.succeeded();
                } else {
                    this.sendTrailers((Stream)stream, trailers, callback);
                }
            });
        }
        HttpChannelOverHTTP2 channel = this.getHttpChannel();
        channel.getSession().newStream(headersFrame, (Promise)promise, channel.getStreamListener());
    }

    private String relativize(String path) {
        try {
            String result = path;
            URI uri = URI.create(result);
            if (uri.isAbsolute()) {
                result = uri.getPath();
            }
            return result.isEmpty() ? "/" : result;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not relativize " + path, new Object[0]);
            }
            return path;
        }
    }

    protected void sendContent(HttpExchange exchange, HttpContent content, Callback callback) {
        if (content.isConsumed()) {
            callback.succeeded();
        } else {
            Stream stream = this.getHttpChannel().getStream();
            Supplier trailerSupplier = exchange.getRequest().getTrailers();
            this.sendContent(stream, content, trailerSupplier, callback);
        }
    }

    private void sendContent(Stream stream, HttpContent content, Supplier<HttpFields> trailerSupplier, Callback callback) {
        boolean lastContent = content.isLast();
        HttpFields trailers = null;
        boolean endStream = false;
        if (lastContent) {
            trailers = trailerSupplier == null ? null : trailerSupplier.get();
            endStream = trailers == null || trailers.size() == 0;
        }
        DataFrame dataFrame = new DataFrame(stream.getId(), content.getByteBuffer(), endStream);
        HttpFields fTrailers = trailers;
        stream.data(dataFrame, endStream || !lastContent ? callback : Callback.from(() -> this.sendTrailers(stream, fTrailers, callback), arg_0 -> ((Callback)callback).failed(arg_0)));
    }

    private void sendTrailers(Stream stream, HttpFields trailers, Callback callback) {
        MetaData metaData = new MetaData(HttpVersion.HTTP_2, trailers);
        HeadersFrame trailersFrame = new HeadersFrame(stream.getId(), metaData, null, true);
        stream.headers(trailersFrame, callback);
    }

    private /* synthetic */ void lambda$sendHeaders$1(HttpRequest request, Callback callback, HttpContent content, Supplier trailerSupplier, Stream stream) {
        if (this.expects100Continue((Request)request)) {
            callback.succeeded();
        } else {
            boolean advanced = content.advance();
            boolean lastContent = content.isLast();
            if (advanced || lastContent) {
                this.sendContent(stream, content, trailerSupplier, callback);
            } else {
                callback.succeeded();
            }
        }
    }

    private static class HeadersPromise
    implements Promise<Stream> {
        private final HttpRequest request;
        private final Callback callback;
        private final Consumer<Stream> succeed;

        private HeadersPromise(HttpRequest request, Callback callback, Consumer<Stream> succeed) {
            this.request = request;
            this.callback = callback;
            this.succeed = succeed;
        }

        public void succeeded(Stream stream) {
            long idleTimeout = this.request.getIdleTimeout();
            if (idleTimeout >= 0L) {
                stream.setIdleTimeout(idleTimeout);
            }
            this.succeed.accept(stream);
        }

        public void failed(Throwable x) {
            this.callback.failed(x);
        }
    }
}

