/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicMarkableReference;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.http.HttpConnectionOverHTTP2;
import org.eclipse.jetty.http2.frames.GoAwayFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.util.Promise;

class HTTPSessionListenerPromise
extends Session.Listener.Adapter
implements Promise<Session> {
    private final AtomicMarkableReference<HttpConnectionOverHTTP2> connection = new AtomicMarkableReference<Object>(null, false);
    private final Map<String, Object> context;

    HTTPSessionListenerPromise(Map<String, Object> context) {
        this.context = context;
    }

    public void succeeded(Session session) {
    }

    public void failed(Throwable failure) {
        this.failConnectionPromise(failure);
    }

    private HttpDestination destination() {
        return (HttpDestination)this.context.get("org.eclipse.jetty.client.destination");
    }

    private Promise<Connection> connectionPromise() {
        return (Promise)this.context.get("org.eclipse.jetty.client.connection.promise");
    }

    public void onSettings(Session session, SettingsFrame frame) {
        HttpDestination destination;
        Map settings = frame.getSettings();
        if (settings.containsKey(3) && (destination = this.destination()) instanceof HttpDestination.Multiplexed) {
            ((HttpDestination.Multiplexed)destination).setMaxRequestsPerConnection(((Integer)settings.get(3)).intValue());
        }
        if (!this.connection.isMarked()) {
            this.onServerPreface(session);
        }
    }

    private void onServerPreface(Session session) {
        HttpConnectionOverHTTP2 connection = this.newHttpConnection(this.destination(), session);
        if (this.connection.compareAndSet(null, connection, false, true)) {
            this.connectionPromise().succeeded((Object)connection);
        }
    }

    protected HttpConnectionOverHTTP2 newHttpConnection(HttpDestination destination, Session session) {
        return new HttpConnectionOverHTTP2(destination, session);
    }

    public void onClose(Session session, GoAwayFrame frame) {
        if (this.failConnectionPromise(new ClosedChannelException())) {
            return;
        }
        HttpConnectionOverHTTP2 connection = this.connection.getReference();
        if (connection != null) {
            this.onClose(connection, frame);
        }
    }

    void onClose(HttpConnectionOverHTTP2 connection, GoAwayFrame frame) {
    }

    public boolean onIdleTimeout(Session session) {
        long idleTimeout = ((HTTP2Session)session).getEndPoint().getIdleTimeout();
        if (this.failConnectionPromise(new TimeoutException("Idle timeout expired: " + idleTimeout + " ms"))) {
            return true;
        }
        HttpConnectionOverHTTP2 connection = this.connection.getReference();
        if (connection != null) {
            return connection.onIdleTimeout(idleTimeout);
        }
        return true;
    }

    public void onFailure(Session session, Throwable failure) {
        if (this.failConnectionPromise(failure)) {
            return;
        }
        HttpConnectionOverHTTP2 connection = this.connection.getReference();
        if (connection != null) {
            connection.close(failure);
        }
    }

    private boolean failConnectionPromise(Throwable failure) {
        boolean result = this.connection.compareAndSet(null, null, false, true);
        if (result) {
            this.connectionPromise().failed(failure);
        }
        return result;
    }
}

