/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.HTTP2ClientConnectionFactory;
import org.eclipse.jetty.http2.client.http.HTTPSessionListenerPromise;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;

public class ClientConnectionFactoryOverHTTP2
implements ClientConnectionFactory {
    private final ClientConnectionFactory factory = new HTTP2ClientConnectionFactory();
    private final HTTP2Client client;

    public ClientConnectionFactoryOverHTTP2(HTTP2Client client) {
        this.client = client;
    }

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HTTPSessionListenerPromise listenerPromise = new HTTPSessionListenerPromise(context);
        context.put("org.eclipse.jetty.client.http2", this.client);
        context.put("org.eclipse.jetty.client.http2.sessionListener", (Object)listenerPromise);
        context.put("org.eclipse.jetty.client.http2.sessionPromise", (Object)listenerPromise);
        return this.factory.newConnection(endPoint, context);
    }

    public static class H2C
    extends ClientConnectionFactory.Info {
        public H2C(HTTP2Client client) {
            super(List.of("h2c"), (ClientConnectionFactory)new ClientConnectionFactoryOverHTTP2(client));
        }
    }

    public static class H2
    extends ClientConnectionFactory.Info {
        public H2(HTTP2Client client) {
            super(List.of("h2"), (ClientConnectionFactory)new ClientConnectionFactoryOverHTTP2(client));
        }
    }
}

