/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.hpack;

import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.hpack.AuthorityHttpField;
import org.eclipse.jetty.http2.hpack.StaticTableHttpField;

public class MetaDataBuilder {
    private final int _maxSize;
    private int _size;
    private int _status;
    private String _method;
    private HttpScheme _scheme;
    private HostPortHttpField _authority;
    private String _path;
    private long _contentLength = Long.MIN_VALUE;
    private HttpFields _fields = new HttpFields(10);

    MetaDataBuilder(int maxSize) {
        this._maxSize = maxSize;
    }

    public int getMaxSize() {
        return this._maxSize;
    }

    public int getSize() {
        return this._size;
    }

    public void emit(HttpField field) {
        int field_size = field.getName().length() + field.getValue().length();
        this._size += field_size;
        if (this._size > this._maxSize) {
            throw new BadMessageException(413, "Header size " + this._size + ">" + this._maxSize);
        }
        if (field instanceof StaticTableHttpField) {
            StaticTableHttpField value = (StaticTableHttpField)field;
            switch (field.getHeader()) {
                case C_STATUS: {
                    this._status = (Integer)value.getStaticValue();
                    break;
                }
                case C_METHOD: {
                    this._method = field.getValue();
                    break;
                }
                case C_SCHEME: {
                    this._scheme = (HttpScheme)value.getStaticValue();
                    break;
                }
                default: {
                    throw new IllegalArgumentException(field.getName());
                }
            }
        } else if (field.getHeader() != null) {
            switch (field.getHeader()) {
                case C_STATUS: {
                    this._status = field.getIntValue();
                    break;
                }
                case C_METHOD: {
                    this._method = field.getValue();
                    break;
                }
                case C_SCHEME: {
                    this._scheme = (HttpScheme)HttpScheme.CACHE.get(field.getValue());
                    break;
                }
                case C_AUTHORITY: {
                    this._authority = field instanceof HostPortHttpField ? (HostPortHttpField)field : new AuthorityHttpField(field.getValue());
                    break;
                }
                case HOST: {
                    if (this._authority == null) {
                        this._authority = field instanceof HostPortHttpField ? (HostPortHttpField)field : new AuthorityHttpField(field.getValue());
                    }
                    this._fields.add(field);
                    break;
                }
                case C_PATH: {
                    this._path = field.getValue();
                    break;
                }
                case CONTENT_LENGTH: {
                    this._contentLength = field.getLongValue();
                    this._fields.add(field);
                    break;
                }
                default: {
                    if (field.getName().charAt(0) != ':') {
                        this._fields.add(field);
                        break;
                    } else {
                        break;
                    }
                }
            }
        } else if (field.getName().charAt(0) != ':') {
            this._fields.add(field);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetaData build() {
        try {
            HttpFields fields = this._fields;
            this._fields = new HttpFields(Math.max(10, fields.size() + 5));
            if (this._method != null) {
                MetaData.Request request = new MetaData.Request(this._method, this._scheme, this._authority, this._path, HttpVersion.HTTP_2, fields, this._contentLength);
                return request;
            }
            if (this._status != 0) {
                MetaData.Response response = new MetaData.Response(HttpVersion.HTTP_2, this._status, fields, this._contentLength);
                return response;
            }
            MetaData metaData = new MetaData(HttpVersion.HTTP_2, fields, this._contentLength);
            return metaData;
        }
        finally {
            this._status = 0;
            this._method = null;
            this._scheme = null;
            this._authority = null;
            this._path = null;
            this._size = 0;
            this._contentLength = Long.MIN_VALUE;
        }
    }

    public void checkSize(int length, boolean huffman) {
        if (huffman) {
            length = length * 4 / 3;
        }
        if (this._size + length > this._maxSize) {
            throw new BadMessageException(413, "Header size " + (this._size + length) + ">" + this._maxSize);
        }
    }
}

