/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.hpack;

import java.nio.ByteBuffer;
import java.util.EnumSet;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.PreEncodedHttpField;
import org.eclipse.jetty.http2.hpack.HpackContext;
import org.eclipse.jetty.http2.hpack.Huffman;
import org.eclipse.jetty.http2.hpack.NBitInteger;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HpackEncoder {
    public static final Logger LOG = Log.getLogger(HpackEncoder.class);
    private static final HttpField[] __status = new HttpField[599];
    private static final EnumSet<HttpHeader> __DO_NOT_HUFFMAN = EnumSet.of(HttpHeader.AUTHORIZATION, HttpHeader.CONTENT_MD5, HttpHeader.PROXY_AUTHENTICATE, HttpHeader.PROXY_AUTHORIZATION);
    private static final EnumSet<HttpHeader> __DO_NOT_INDEX = EnumSet.of(HttpHeader.AUTHORIZATION, new HttpHeader[]{HttpHeader.CONTENT_MD5, HttpHeader.CONTENT_RANGE, HttpHeader.ETAG, HttpHeader.IF_MODIFIED_SINCE, HttpHeader.IF_UNMODIFIED_SINCE, HttpHeader.IF_NONE_MATCH, HttpHeader.IF_RANGE, HttpHeader.IF_MATCH, HttpHeader.LOCATION, HttpHeader.RANGE, HttpHeader.RETRY_AFTER, HttpHeader.EXPIRES, HttpHeader.LAST_MODIFIED, HttpHeader.SET_COOKIE, HttpHeader.SET_COOKIE2});
    private static final EnumSet<HttpHeader> __NEVER_INDEX = EnumSet.of(HttpHeader.AUTHORIZATION, HttpHeader.SET_COOKIE, HttpHeader.SET_COOKIE2);
    private final HpackContext _context;
    private final boolean _debug;
    private int _remoteMaxHeaderTableSize;
    private int _localMaxHeaderTableSize;

    public HpackEncoder() {
        this(4096, 4096);
    }

    public HpackEncoder(int localMaxHeaderTableSize) {
        this(localMaxHeaderTableSize, 4096);
    }

    public HpackEncoder(int localMaxHeaderTableSize, int remoteMaxHeaderTableSize) {
        this._context = new HpackContext(remoteMaxHeaderTableSize);
        this._remoteMaxHeaderTableSize = remoteMaxHeaderTableSize;
        this._localMaxHeaderTableSize = localMaxHeaderTableSize;
        this._debug = LOG.isDebugEnabled();
    }

    public HpackContext getContext() {
        return this._context;
    }

    public void setRemoteMaxHeaderTableSize(int remoteMaxHeaderTableSize) {
        this._remoteMaxHeaderTableSize = remoteMaxHeaderTableSize;
    }

    public void setLocalMaxHeaderTableSize(int localMaxHeaderTableSize) {
        this._localMaxHeaderTableSize = localMaxHeaderTableSize;
    }

    public void encode(MetaData metadata, ByteBufferPool.Lease lease, int buffersize) {
        ByteBuffer buffer = lease.acquire(buffersize, false);
        lease.append(buffer, true);
        BufferUtil.clearToFill((ByteBuffer)buffer);
        this.encode(buffer, metadata);
        BufferUtil.flipToFlush((ByteBuffer)buffer, (int)0);
    }

    public void encode(ByteBuffer buffer, MetaData metadata) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("CtxTbl[%x] encoding", this._context.hashCode()), new Object[0]);
        }
        int pos = buffer.position();
        int maxHeaderTableSize = Math.min(this._remoteMaxHeaderTableSize, this._localMaxHeaderTableSize);
        if (maxHeaderTableSize != this._context.getMaxHeaderTableSize()) {
            this.encodeMaxHeaderTableSize(buffer, maxHeaderTableSize);
        }
        if (metadata.isRequest()) {
            MetaData.Request request = (MetaData.Request)metadata;
            String scheme = request.getURI().getScheme();
            this.encode(buffer, new HttpField(HttpHeader.C_SCHEME, scheme == null ? HttpScheme.HTTP.asString() : scheme));
            this.encode(buffer, new HttpField(HttpHeader.C_METHOD, request.getMethod()));
            this.encode(buffer, new HttpField(HttpHeader.C_AUTHORITY, request.getURI().getAuthority()));
            this.encode(buffer, new HttpField(HttpHeader.C_PATH, request.getURI().getPathQuery()));
        } else if (metadata.isResponse()) {
            HttpField status;
            MetaData.Response response = (MetaData.Response)metadata;
            int code = response.getStatus();
            HttpField httpField = status = code < __status.length ? __status[code] : null;
            if (status == null) {
                status = new HttpField.IntValueHttpField(HttpHeader.C_STATUS, code);
            }
            this.encode(buffer, status);
        }
        for (HttpField field : metadata) {
            this.encode(buffer, field);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("CtxTbl[%x] encoded %d octets", this._context.hashCode(), buffer.position() - pos), new Object[0]);
        }
    }

    public void encodeMaxHeaderTableSize(ByteBuffer buffer, int maxHeaderTableSize) {
        if (maxHeaderTableSize > this._remoteMaxHeaderTableSize) {
            throw new IllegalArgumentException();
        }
        buffer.put((byte)32);
        NBitInteger.encode(buffer, 5, maxHeaderTableSize);
        this._context.resize(maxHeaderTableSize);
    }

    private void encode(ByteBuffer buffer, HttpField field) {
        int p = this._debug ? buffer.position() : -1;
        String encoding = null;
        HpackContext.Entry entry = this._context.get(field);
        if (entry != null) {
            if (entry.isStatic()) {
                buffer.put(((HpackContext.StaticEntry)entry).getEncodedField());
                if (this._debug) {
                    encoding = "IdxFieldS1";
                }
            } else {
                int index = this._context.index(entry);
                buffer.put((byte)-128);
                NBitInteger.encode(buffer, 7, index);
                if (this._debug) {
                    encoding = "IdxField" + (entry.isStatic() ? "S" : "") + (1 + NBitInteger.octectsNeeded(7, index));
                }
            }
        } else {
            boolean indexed;
            HttpHeader header = field.getHeader();
            if (header == null) {
                HpackContext.Entry name = this._context.get(field.getName());
                if (name == null) {
                    indexed = true;
                    this.encodeName(buffer, (byte)64, 6, field.getName(), null);
                    this.encodeValue(buffer, true, field.getValue());
                    if (this._debug) {
                        encoding = "LitHuffNHuffVIdx";
                    }
                } else {
                    indexed = false;
                    this.encodeName(buffer, (byte)0, 4, field.getName(), null);
                    this.encodeValue(buffer, true, field.getValue());
                    if (this._debug) {
                        encoding = "LitHuffNHuffV!Idx";
                    }
                }
            } else {
                HpackContext.Entry name = this._context.get(header);
                if (__DO_NOT_INDEX.contains(header)) {
                    indexed = false;
                    boolean never_index = __NEVER_INDEX.contains(header);
                    boolean huffman = !__DO_NOT_HUFFMAN.contains(header);
                    this.encodeName(buffer, never_index ? (byte)16 : 0, 4, header.asString(), name);
                    this.encodeValue(buffer, huffman, field.getValue());
                    if (this._debug) {
                        encoding = "Lit" + (name == null ? "HuffN" : "IdxN" + (name.isStatic() ? "S" : "") + (1 + NBitInteger.octectsNeeded(4, this._context.index(name)))) + (huffman ? "HuffV" : "LitV") + (indexed ? "Idx" : (never_index ? "!!Idx" : "!Idx"));
                    }
                } else if (header == HttpHeader.CONTENT_LENGTH && field.getValue().length() > 1) {
                    indexed = false;
                    this.encodeName(buffer, (byte)0, 4, header.asString(), name);
                    this.encodeValue(buffer, true, field.getValue());
                    if (this._debug) {
                        encoding = "LitIdxNS" + (1 + NBitInteger.octectsNeeded(4, this._context.index(name))) + "HuffV!Idx";
                    }
                } else if (field instanceof PreEncodedHttpField) {
                    indexed = true;
                    ((PreEncodedHttpField)field).putTo(buffer, HttpVersion.HTTP_2);
                    if (this._debug) {
                        encoding = (name == null ? "LitHuffN" : "LitIdxN" + (name.isStatic() ? "S" : "") + (1 + NBitInteger.octectsNeeded(6, this._context.index(name)))) + "HuffVIdx";
                    }
                } else {
                    indexed = true;
                    boolean huffman = !__DO_NOT_HUFFMAN.contains(header);
                    this.encodeName(buffer, (byte)64, 6, header.asString(), name);
                    this.encodeValue(buffer, huffman, field.getValue());
                    if (this._debug) {
                        encoding = (name == null ? "LitHuffN" : "LitIdxN" + (name.isStatic() ? "S" : "") + (1 + NBitInteger.octectsNeeded(6, this._context.index(name)))) + (huffman ? "HuffVIdx" : "LitVIdx");
                    }
                }
            }
            if (indexed) {
                this._context.add(field);
            }
        }
        if (this._debug) {
            int e = buffer.position();
            if (LOG.isDebugEnabled()) {
                LOG.debug("encode {}:'{}' to '{}'", new Object[]{encoding, field, TypeUtil.toHexString((byte[])buffer.array(), (int)(buffer.arrayOffset() + p), (int)(e - p))});
            }
        }
    }

    private void encodeName(ByteBuffer buffer, byte mask, int bits, String name, HpackContext.Entry entry) {
        buffer.put(mask);
        if (entry == null) {
            buffer.put((byte)-128);
            NBitInteger.encode(buffer, 7, Huffman.octetsNeededLC(name));
            Huffman.encodeLC(buffer, name);
        } else {
            NBitInteger.encode(buffer, bits, this._context.index(entry));
        }
    }

    private void encodeValue(ByteBuffer buffer, boolean huffman, String value) {
        if (huffman) {
            buffer.put((byte)-128);
            NBitInteger.encode(buffer, 7, Huffman.octetsNeeded(value));
            Huffman.encode(buffer, value);
        } else {
            buffer.put((byte)0);
            NBitInteger.encode(buffer, 7, value.length());
            for (int i = 0; i < value.length(); ++i) {
                char c = value.charAt(i);
                if (c < ' ' || c > '\u007f') {
                    throw new IllegalArgumentException();
                }
                buffer.put((byte)c);
            }
        }
    }

    static {
        for (HttpStatus.Code code : HttpStatus.Code.values()) {
            HpackEncoder.__status[code.getCode()] = new HttpField(":status", Integer.toString(code.getCode()));
        }
    }
}

