/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.frames;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.FrameType;
import org.eclipse.jetty.util.BufferUtil;

public class GoAwayFrame
extends Frame {
    private final int lastStreamId;
    private final int error;
    private final byte[] payload;

    public GoAwayFrame(int lastStreamId, int error, byte[] payload) {
        super(FrameType.GO_AWAY);
        this.lastStreamId = lastStreamId;
        this.error = error;
        this.payload = payload;
    }

    public int getLastStreamId() {
        return this.lastStreamId;
    }

    public int getError() {
        return this.error;
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public String tryConvertPayload() {
        if (this.payload == null) {
            return "";
        }
        ByteBuffer buffer = BufferUtil.toBuffer((byte[])this.payload);
        try {
            return BufferUtil.toUTF8String((ByteBuffer)buffer);
        }
        catch (Throwable x) {
            return BufferUtil.toDetailString((ByteBuffer)buffer);
        }
    }

    @Override
    public String toString() {
        ErrorCode errorCode = ErrorCode.from(this.error);
        return String.format("%s,%d/%s/%s", super.toString(), this.lastStreamId, errorCode != null ? errorCode.toString() : String.valueOf(this.error), this.tryConvertPayload());
    }
}

