/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public abstract class AbstractFlowControlStrategy
implements FlowControlStrategy {
    protected static final Logger LOG = Log.getLogger(FlowControlStrategy.class);
    private int initialStreamSendWindow;
    private int initialStreamRecvWindow;

    public AbstractFlowControlStrategy(int initialStreamSendWindow) {
        this.initialStreamSendWindow = initialStreamSendWindow;
        this.initialStreamRecvWindow = 65535;
    }

    protected int getInitialStreamSendWindow() {
        return this.initialStreamSendWindow;
    }

    protected int getInitialStreamRecvWindow() {
        return this.initialStreamRecvWindow;
    }

    @Override
    public void onNewStream(IStream stream, boolean local) {
        stream.updateSendWindow(this.initialStreamSendWindow);
        stream.updateRecvWindow(this.initialStreamRecvWindow);
    }

    @Override
    public void onStreamTerminated(IStream stream, boolean local) {
    }

    @Override
    public void updateInitialStreamWindow(ISession session, int initialStreamWindow, boolean local) {
        int previousInitialStreamWindow;
        if (local) {
            previousInitialStreamWindow = this.getInitialStreamRecvWindow();
            this.initialStreamRecvWindow = initialStreamWindow;
        } else {
            previousInitialStreamWindow = this.getInitialStreamSendWindow();
            this.initialStreamSendWindow = initialStreamWindow;
        }
        int delta = initialStreamWindow - previousInitialStreamWindow;
        for (Stream stream : session.getStreams()) {
            if (local) {
                ((IStream)stream).updateRecvWindow(delta);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Updated initial stream recv window {} -> {} for {}", new Object[]{previousInitialStreamWindow, initialStreamWindow, stream});
                continue;
            }
            session.onWindowUpdate((IStream)stream, new WindowUpdateFrame(stream.getId(), delta));
        }
    }

    @Override
    public void onWindowUpdate(ISession session, IStream stream, WindowUpdateFrame frame) {
        int delta = frame.getWindowDelta();
        if (frame.getStreamId() > 0) {
            if (stream != null) {
                int oldSize = stream.updateSendWindow(delta);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Updated stream send window {} -> {} for {}", new Object[]{oldSize, oldSize + delta, stream});
                }
            }
        } else {
            int oldSize = session.updateSendWindow(delta);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Updated session send window {} -> {} for {}", new Object[]{oldSize, oldSize + delta, session});
            }
        }
    }

    @Override
    public void onDataReceived(ISession session, IStream stream, int length) {
        int oldSize = session.updateRecvWindow(-length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Data received, updated session recv window {} -> {} for {}", new Object[]{oldSize, oldSize - length, session});
        }
        if (stream != null) {
            oldSize = stream.updateRecvWindow(-length);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Data received, updated stream recv window {} -> {} for {}", new Object[]{oldSize, oldSize - length, stream});
            }
        }
    }

    @Override
    public void windowUpdate(ISession session, IStream stream, WindowUpdateFrame frame) {
    }

    @Override
    public void onDataSending(IStream stream, int length) {
        if (length == 0) {
            return;
        }
        ISession session = stream.getSession();
        int oldSize = session.updateSendWindow(-length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated session send window {} -> {} for {}", new Object[]{oldSize, oldSize - length, session});
        }
        oldSize = stream.updateSendWindow(-length);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Updated stream send window {} -> {} for {}", new Object[]{oldSize, oldSize - length, stream});
        }
    }

    @Override
    public void onDataSent(IStream stream, int length) {
    }

    @Override
    public void onSessionStalled(ISession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Session stalled {}", new Object[]{session});
        }
    }

    @Override
    public void onStreamStalled(IStream stream) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Stream stalled {}", new Object[]{stream});
        }
    }
}

