/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.jetty.http2.FlowControlStrategy;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.HTTP2Client;
import org.eclipse.jetty.http2.client.HTTP2ClientSession;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.PrefaceFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.http2.generator.Generator;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ReservedThreadExecutor;
import org.eclipse.jetty.util.thread.Scheduler;

public class HTTP2ClientConnectionFactory
implements ClientConnectionFactory {
    public static final String CLIENT_CONTEXT_KEY = "http2.client";
    public static final String BYTE_BUFFER_POOL_CONTEXT_KEY = "http2.client.byteBufferPool";
    public static final String EXECUTOR_CONTEXT_KEY = "http2.client.executor";
    public static final String SCHEDULER_CONTEXT_KEY = "http2.client.scheduler";
    public static final String SESSION_LISTENER_CONTEXT_KEY = "http2.client.sessionListener";
    public static final String SESSION_PROMISE_CONTEXT_KEY = "http2.client.sessionPromise";
    private final Connection.Listener connectionListener = new ConnectionListener();

    public Connection newConnection(EndPoint endPoint, Map<String, Object> context) throws IOException {
        HTTP2Client client = (HTTP2Client)((Object)context.get(CLIENT_CONTEXT_KEY));
        ByteBufferPool byteBufferPool = (ByteBufferPool)context.get(BYTE_BUFFER_POOL_CONTEXT_KEY);
        Executor executor = (Executor)context.get(EXECUTOR_CONTEXT_KEY);
        Scheduler scheduler = (Scheduler)context.get(SCHEDULER_CONTEXT_KEY);
        Session.Listener listener = (Session.Listener)context.get(SESSION_LISTENER_CONTEXT_KEY);
        Promise promise = (Promise)context.get(SESSION_PROMISE_CONTEXT_KEY);
        Generator generator = new Generator(byteBufferPool);
        FlowControlStrategy flowControl = client.getFlowControlStrategyFactory().newFlowControlStrategy();
        HTTP2ClientSession session = new HTTP2ClientSession(scheduler, endPoint, generator, listener, flowControl);
        Parser parser = new Parser(byteBufferPool, (Parser.Listener)session, 4096, 8192);
        ReservedThreadExecutor reservedExecutor = this.provideReservedThreadExecutor(client, executor);
        HTTP2ClientConnection connection = new HTTP2ClientConnection(client, byteBufferPool, reservedExecutor, endPoint, parser, (ISession)session, client.getInputBufferSize(), promise, listener);
        connection.addListener(this.connectionListener);
        return this.customize((Connection)connection, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReservedThreadExecutor provideReservedThreadExecutor(HTTP2Client client, Executor executor) {
        HTTP2ClientConnectionFactory hTTP2ClientConnectionFactory = this;
        synchronized (hTTP2ClientConnectionFactory) {
            ReservedThreadExecutor reservedExecutor = (ReservedThreadExecutor)client.getBean(ReservedThreadExecutor.class);
            if (reservedExecutor == null) {
                reservedExecutor = new ReservedThreadExecutor(executor, 0);
                client.addManaged((LifeCycle)reservedExecutor);
            }
            return reservedExecutor;
        }
    }

    private class ConnectionListener
    implements Connection.Listener {
        private ConnectionListener() {
        }

        public void onOpened(Connection connection) {
            HTTP2ClientConnection http2Connection = (HTTP2ClientConnection)connection;
            http2Connection.client.addManaged((LifeCycle)http2Connection.getSession());
        }

        public void onClosed(Connection connection) {
            HTTP2ClientConnection http2Connection = (HTTP2ClientConnection)connection;
            http2Connection.client.removeBean(http2Connection.getSession());
        }
    }

    private class HTTP2ClientConnection
    extends HTTP2Connection
    implements Callback {
        private final HTTP2Client client;
        private final Promise<Session> promise;
        private final Session.Listener listener;

        private HTTP2ClientConnection(HTTP2Client client, ByteBufferPool byteBufferPool, ReservedThreadExecutor executor, EndPoint endpoint, Parser parser, ISession session, int bufferSize, Promise<Session> promise, Session.Listener listener) {
            super(byteBufferPool, executor, endpoint, parser, session, bufferSize);
            this.client = client;
            this.promise = promise;
            this.listener = listener;
        }

        public long getMessagesIn() {
            HTTP2ClientSession session = (HTTP2ClientSession)this.getSession();
            return session.getStreamsOpened();
        }

        public long getMessagesOut() {
            HTTP2ClientSession session = (HTTP2ClientSession)this.getSession();
            return session.getStreamsClosed();
        }

        public void onOpen() {
            Map settings = this.listener.onPreface((Session)this.getSession());
            if (settings == null) {
                settings = Collections.emptyMap();
            }
            PrefaceFrame prefaceFrame = new PrefaceFrame();
            SettingsFrame settingsFrame = new SettingsFrame(settings, false);
            ISession session = this.getSession();
            int windowDelta = this.client.getInitialSessionRecvWindow() - 65535;
            if (windowDelta > 0) {
                session.updateRecvWindow(windowDelta);
                session.frames(null, (Callback)this, (Frame)prefaceFrame, new Frame[]{settingsFrame, new WindowUpdateFrame(0, windowDelta)});
            } else {
                session.frames(null, (Callback)this, (Frame)prefaceFrame, new Frame[]{settingsFrame});
            }
            super.onOpen();
        }

        public void succeeded() {
            this.promise.succeeded((Object)this.getSession());
        }

        public void failed(Throwable x) {
            this.close();
            this.promise.failed(x);
        }
    }
}

