/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import org.eclipse.jetty.alpn.client.ALPNClientConnectionFactory;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.client.HTTP2ClientConnectionFactory;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.ClientConnectionFactory;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ManagedSelector;
import org.eclipse.jetty.io.MappedByteBufferPool;
import org.eclipse.jetty.io.SelectChannelEndPoint;
import org.eclipse.jetty.io.SelectorManager;
import org.eclipse.jetty.io.ssl.SslClientConnectionFactory;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.ContainerLifeCycle;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ScheduledExecutorScheduler;
import org.eclipse.jetty.util.thread.Scheduler;

public class HTTP2Client
extends ContainerLifeCycle {
    private Executor executor;
    private Scheduler scheduler;
    private ByteBufferPool bufferPool;
    private ClientConnectionFactory connectionFactory;
    private Queue<ISession> sessions;
    private SelectorManager selector;
    private int selectors = 1;
    private long idleTimeout = 30000L;
    private long connectTimeout = 10000L;
    private List<String> protocols = Arrays.asList("h2", "h2-17", "h2-16", "h2-15", "h2-14");

    protected void doStart() throws Exception {
        if (this.executor == null) {
            this.setExecutor((Executor)new QueuedThreadPool());
        }
        if (this.scheduler == null) {
            this.setScheduler((Scheduler)new ScheduledExecutorScheduler());
        }
        if (this.bufferPool == null) {
            this.setByteBufferPool((ByteBufferPool)new MappedByteBufferPool());
        }
        if (this.connectionFactory == null) {
            this.setClientConnectionFactory(new HTTP2ClientConnectionFactory());
        }
        if (this.sessions == null) {
            this.sessions = new ConcurrentLinkedQueue<ISession>();
            this.addBean(this.sessions);
        }
        if (this.selector == null) {
            this.selector = this.newSelectorManager();
            this.addBean(this.selector);
        }
        this.selector.setConnectTimeout(this.getConnectTimeout());
        super.doStart();
    }

    protected SelectorManager newSelectorManager() {
        return new ClientSelectorManager(this.getExecutor(), this.getScheduler(), this.getSelectors());
    }

    protected void doStop() throws Exception {
        this.closeConnections();
        super.doStop();
    }

    public Executor getExecutor() {
        return this.executor;
    }

    public void setExecutor(Executor executor) {
        this.updateBean(this.executor, executor);
        this.executor = executor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void setScheduler(Scheduler scheduler) {
        this.updateBean(this.scheduler, scheduler);
        this.scheduler = scheduler;
    }

    public ByteBufferPool getByteBufferPool() {
        return this.bufferPool;
    }

    public void setByteBufferPool(ByteBufferPool bufferPool) {
        this.updateBean(this.bufferPool, bufferPool);
        this.bufferPool = bufferPool;
    }

    public ClientConnectionFactory getClientConnectionFactory() {
        return this.connectionFactory;
    }

    public void setClientConnectionFactory(ClientConnectionFactory connectionFactory) {
        this.updateBean(this.connectionFactory, connectionFactory);
        this.connectionFactory = connectionFactory;
    }

    public int getSelectors() {
        return this.selectors;
    }

    public void setSelectors(int selectors) {
        this.selectors = selectors;
    }

    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
    }

    public long getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(long connectTimeout) {
        this.connectTimeout = connectTimeout;
        SelectorManager selector = this.selector;
        if (selector != null) {
            selector.setConnectTimeout(connectTimeout);
        }
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    public void setProtocols(List<String> protocols) {
        this.protocols = protocols;
    }

    public void connect(InetSocketAddress address, Session.Listener listener, Promise<Session> promise) {
        this.connect(null, address, listener, promise);
    }

    public void connect(SslContextFactory sslContextFactory, InetSocketAddress address, Session.Listener listener, Promise<Session> promise) {
        this.connect(sslContextFactory, address, listener, promise, new HashMap<String, Object>());
    }

    public void connect(SslContextFactory sslContextFactory, InetSocketAddress address, Session.Listener listener, Promise<Session> promise, Map<String, Object> context) {
        try {
            SocketChannel channel = SocketChannel.open();
            this.configure(channel);
            channel.configureBlocking(false);
            context.put("http2.client", (Object)this);
            context.put("http2.client.sessionListener", listener);
            context.put("http2.client.sessionPromise", promise);
            if (sslContextFactory != null) {
                context.put("ssl.context.factory", sslContextFactory);
            }
            context.put("ssl.peer.host", address.getHostString());
            context.put("ssl.peer.port", address.getPort());
            if (channel.connect(address)) {
                this.selector.accept(channel, context);
            } else {
                this.selector.connect(channel, context);
            }
        }
        catch (Throwable x) {
            promise.failed(x);
        }
    }

    protected void configure(SocketChannel channel) throws IOException {
        channel.socket().setTcpNoDelay(true);
    }

    private void closeConnections() {
        for (ISession session : this.sessions) {
            session.close(ErrorCode.NO_ERROR.code, null, Callback.NOOP);
        }
        this.sessions.clear();
    }

    public boolean addSession(ISession session) {
        return this.sessions.offer(session);
    }

    public boolean removeSession(ISession session) {
        return this.sessions.remove(session);
    }

    private class ClientSelectorManager
    extends SelectorManager {
        private ClientSelectorManager(Executor executor, Scheduler scheduler, int selectors) {
            super(executor, scheduler, selectors);
        }

        protected EndPoint newEndPoint(SocketChannel channel, ManagedSelector selector, SelectionKey selectionKey) throws IOException {
            return new SelectChannelEndPoint(channel, selector, selectionKey, this.getScheduler(), HTTP2Client.this.getIdleTimeout());
        }

        public Connection newConnection(SocketChannel channel, EndPoint endpoint, Object attachment) throws IOException {
            Map context = (Map)attachment;
            context.put("http2.client.byteBufferPool", HTTP2Client.this.getByteBufferPool());
            context.put("http2.client.executor", this.getExecutor());
            context.put("http2.client.scheduler", this.getScheduler());
            ClientConnectionFactory factory = HTTP2Client.this.getClientConnectionFactory();
            SslContextFactory sslContextFactory = (SslContextFactory)context.get("ssl.context.factory");
            if (sslContextFactory != null) {
                ALPNClientConnectionFactory alpn = new ALPNClientConnectionFactory(this.getExecutor(), factory, HTTP2Client.this.getProtocols());
                factory = new SslClientConnectionFactory(sslContextFactory, HTTP2Client.this.getByteBufferPool(), this.getExecutor(), (ClientConnectionFactory)alpn);
            }
            return factory.newConnection(endpoint, context);
        }

        protected void connectionFailed(SocketChannel channel, Throwable failure, Object attachment) {
            Map context = (Map)attachment;
            if (LOG.isDebugEnabled()) {
                Object host = context.get("ssl.peer.host");
                Object port = context.get("ssl.peer.port");
                LOG.debug("Could not connect to {}:{}", new Object[]{host, port});
            }
            Promise promise = (Promise)context.get("http2.client.sessionPromise");
            promise.failed(failure);
        }
    }
}

