/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server.proxy;

import java.net.URI;
import java.util.List;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpClientTransport;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.fcgi.client.http.HttpClientTransportOverFCGI;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.proxy.AsyncProxyServlet;

public class FastCGIProxyServlet
extends AsyncProxyServlet.Transparent {
    public static final String SCRIPT_ROOT_INIT_PARAM = "scriptRoot";
    public static final String SCRIPT_PATTERN_INIT_PARAM = "scriptPattern";
    public static final String ORIGINAL_URI_ATTRIBUTE_INIT_PARAM = "originalURIAttribute";
    public static final String FASTCGI_HTTPS_INIT_PARAM = "fastCGI.HTTPS";
    private static final String REMOTE_ADDR_ATTRIBUTE = FastCGIProxyServlet.class.getName() + ".remoteAddr";
    private static final String REMOTE_PORT_ATTRIBUTE = FastCGIProxyServlet.class.getName() + ".remotePort";
    private static final String SERVER_NAME_ATTRIBUTE = FastCGIProxyServlet.class.getName() + ".serverName";
    private static final String SERVER_ADDR_ATTRIBUTE = FastCGIProxyServlet.class.getName() + ".serverAddr";
    private static final String SERVER_PORT_ATTRIBUTE = FastCGIProxyServlet.class.getName() + ".serverPort";
    private static final String SCHEME_ATTRIBUTE = FastCGIProxyServlet.class.getName() + ".scheme";
    private static final String REQUEST_URI_ATTRIBUTE = FastCGIProxyServlet.class.getName() + ".requestURI";
    private Pattern scriptPattern;
    private String originalURIAttribute;
    private boolean fcgiHTTPS;

    public void init() throws ServletException {
        super.init();
        String value = this.getInitParameter(SCRIPT_PATTERN_INIT_PARAM);
        if (value == null) {
            value = "(.+?\\.php)";
        }
        this.scriptPattern = Pattern.compile(value);
        this.originalURIAttribute = this.getInitParameter(ORIGINAL_URI_ATTRIBUTE_INIT_PARAM);
        this.fcgiHTTPS = Boolean.parseBoolean(this.getInitParameter(FASTCGI_HTTPS_INIT_PARAM));
    }

    protected HttpClient newHttpClient() {
        ServletConfig config = this.getServletConfig();
        String scriptRoot = config.getInitParameter(SCRIPT_ROOT_INIT_PARAM);
        if (scriptRoot == null) {
            throw new IllegalArgumentException("Mandatory parameter 'scriptRoot' not configured");
        }
        return new HttpClient((HttpClientTransport)new ProxyHttpClientTransportOverFCGI(scriptRoot), null);
    }

    protected void sendProxyRequest(HttpServletRequest request, HttpServletResponse proxyResponse, Request proxyRequest) {
        List cookies;
        proxyRequest.attribute(REMOTE_ADDR_ATTRIBUTE, (Object)request.getRemoteAddr());
        proxyRequest.attribute(REMOTE_PORT_ATTRIBUTE, (Object)String.valueOf(request.getRemotePort()));
        proxyRequest.attribute(SERVER_NAME_ATTRIBUTE, (Object)request.getServerName());
        proxyRequest.attribute(SERVER_ADDR_ATTRIBUTE, (Object)request.getLocalAddr());
        proxyRequest.attribute(SERVER_PORT_ATTRIBUTE, (Object)String.valueOf(request.getLocalPort()));
        proxyRequest.attribute(SCHEME_ATTRIBUTE, (Object)request.getScheme());
        String originalURI = null;
        if (this.originalURIAttribute != null) {
            originalURI = (String)request.getAttribute(this.originalURIAttribute);
        }
        if (originalURI == null) {
            String originalPath = (String)request.getAttribute("javax.servlet.forward.request_uri");
            String originalQuery = (String)request.getAttribute("javax.servlet.forward.query_string");
            if (originalPath == null) {
                originalPath = (String)request.getAttribute("javax.servlet.include.request_uri");
                originalQuery = (String)request.getAttribute("javax.servlet.include.query_string");
            }
            if (originalPath != null) {
                originalURI = originalPath;
                if (originalQuery != null) {
                    originalURI = originalURI + "?" + originalQuery;
                }
            }
        }
        if (originalURI != null) {
            proxyRequest.attribute(REQUEST_URI_ATTRIBUTE, (Object)originalURI);
        }
        if (!proxyRequest.getHeaders().containsKey(HttpHeader.HOST.asString())) {
            String host = request.getServerName();
            int port = request.getServerPort();
            if (!this.getHttpClient().isDefaultPort(request.getScheme(), port)) {
                host = host + ":" + port;
            }
            proxyRequest.header(HttpHeader.HOST, host);
            proxyRequest.header(HttpHeader.X_FORWARDED_HOST, host);
        }
        if ((cookies = proxyRequest.getHeaders().getValuesList(HttpHeader.COOKIE.asString())).size() > 1) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < cookies.size(); ++i) {
                if (i > 0) {
                    builder.append("; ");
                }
                String cookie = (String)cookies.get(i);
                builder.append(cookie);
            }
            proxyRequest.header(HttpHeader.COOKIE, null);
            proxyRequest.header(HttpHeader.COOKIE, builder.toString());
        }
        super.sendProxyRequest(request, proxyResponse, proxyRequest);
    }

    protected void customizeFastCGIHeaders(Request proxyRequest, HttpFields fastCGIHeaders) {
        fastCGIHeaders.put("REMOTE_ADDR", (String)proxyRequest.getAttributes().get(REMOTE_ADDR_ATTRIBUTE));
        fastCGIHeaders.put("REMOTE_PORT", (String)proxyRequest.getAttributes().get(REMOTE_PORT_ATTRIBUTE));
        fastCGIHeaders.put("SERVER_NAME", (String)proxyRequest.getAttributes().get(SERVER_NAME_ATTRIBUTE));
        fastCGIHeaders.put("SERVER_ADDR", (String)proxyRequest.getAttributes().get(SERVER_ADDR_ATTRIBUTE));
        fastCGIHeaders.put("SERVER_PORT", (String)proxyRequest.getAttributes().get(SERVER_PORT_ATTRIBUTE));
        if (this.fcgiHTTPS || HttpScheme.HTTPS.is((String)proxyRequest.getAttributes().get(SCHEME_ATTRIBUTE))) {
            fastCGIHeaders.put("HTTPS", "on");
        }
        URI proxyRequestURI = proxyRequest.getURI();
        String rawPath = proxyRequestURI.getRawPath();
        String rawQuery = proxyRequestURI.getRawQuery();
        String requestURI = (String)proxyRequest.getAttributes().get(REQUEST_URI_ATTRIBUTE);
        if (requestURI == null) {
            requestURI = rawPath;
            if (rawQuery != null) {
                requestURI = requestURI + "?" + rawQuery;
            }
        }
        fastCGIHeaders.put("REQUEST_URI", requestURI);
        String scriptName = rawPath;
        Matcher matcher = this.scriptPattern.matcher(rawPath);
        if (matcher.matches()) {
            scriptName = matcher.group(1);
            if (matcher.groupCount() > 1) {
                fastCGIHeaders.put("PATH_INFO", matcher.group(2));
            }
        }
        fastCGIHeaders.put("SCRIPT_NAME", scriptName);
        String root = fastCGIHeaders.get("DOCUMENT_ROOT");
        fastCGIHeaders.put("SCRIPT_FILENAME", root + scriptName);
    }

    private class ProxyHttpClientTransportOverFCGI
    extends HttpClientTransportOverFCGI {
        public ProxyHttpClientTransportOverFCGI(String scriptRoot) {
            super(scriptRoot);
        }

        protected void customize(Request request, HttpFields fastCGIHeaders) {
            super.customize(request, fastCGIHeaders);
            FastCGIProxyServlet.this.customizeFastCGIHeaders(request, fastCGIHeaders);
            if (FastCGIProxyServlet.this._log.isDebugEnabled()) {
                TreeMap<String, String> fcgi = new TreeMap<String, String>();
                for (HttpField field : fastCGIHeaders) {
                    fcgi.put(field.getName(), field.getValue());
                }
                String eol = System.lineSeparator();
                FastCGIProxyServlet.this._log.debug("FastCGI variables{}{}", new Object[]{eol, fcgi.entrySet().stream().map(entry -> String.format("%s: %s", entry.getKey(), entry.getValue())).collect(Collectors.joining(eol))});
            }
        }
    }
}

