/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server;

import java.nio.ByteBuffer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.generator.Flusher;
import org.eclipse.jetty.fcgi.parser.ServerParser;
import org.eclipse.jetty.fcgi.server.HttpChannelOverFCGI;
import org.eclipse.jetty.fcgi.server.HttpTransportOverFCGI;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerFCGIConnection
extends AbstractConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ServerFCGIConnection.class);
    private final ConcurrentMap<Integer, HttpChannelOverFCGI> channels = new ConcurrentHashMap<Integer, HttpChannelOverFCGI>();
    private final Connector connector;
    private final boolean sendStatus200;
    private final Flusher flusher;
    private final HttpConfiguration configuration;
    private final ServerParser parser;
    private boolean useInputDirectByteBuffers;
    private boolean useOutputDirectByteBuffers;

    public ServerFCGIConnection(Connector connector, EndPoint endPoint, HttpConfiguration configuration, boolean sendStatus200) {
        super(endPoint, connector.getExecutor());
        this.connector = connector;
        this.flusher = new Flusher(endPoint);
        this.configuration = configuration;
        this.sendStatus200 = sendStatus200;
        this.parser = new ServerParser((ServerParser.Listener)new ServerListener());
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this.useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this.useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    public void onFillable() {
        EndPoint endPoint = this.getEndPoint();
        ByteBufferPool bufferPool = this.connector.getByteBufferPool();
        ByteBuffer buffer = bufferPool.acquire(this.configuration.getResponseHeaderSize(), this.isUseInputDirectByteBuffers());
        try {
            int read;
            while (true) {
                read = endPoint.fill(buffer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {} bytes from {}", (Object)read, (Object)endPoint);
                }
                if (read <= 0) break;
                this.parse(buffer);
            }
            if (read == 0) {
                bufferPool.release(buffer);
                this.fillInterested();
            } else {
                bufferPool.release(buffer);
                this.shutdown();
            }
        }
        catch (Exception x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to fill endpoint", (Throwable)x);
            }
            bufferPool.release(buffer);
        }
    }

    protected boolean onReadTimeout(Throwable timeout) {
        return this.channels.values().stream().mapToInt(channel -> channel.onIdleTimeout(timeout) ? 0 : 1).sum() == 0;
    }

    private void parse(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            this.parser.parse(buffer);
        }
    }

    private void shutdown() {
        this.flusher.shutdown();
    }

    private class ServerListener
    implements ServerParser.Listener {
        private ServerListener() {
        }

        public void onStart(int request, FCGI.Role role, int flags) {
            HttpChannelOverFCGI channel = new HttpChannelOverFCGI(ServerFCGIConnection.this.connector, ServerFCGIConnection.this.configuration, ServerFCGIConnection.this.getEndPoint(), new HttpTransportOverFCGI(ServerFCGIConnection.this.connector.getByteBufferPool(), ServerFCGIConnection.this.isUseOutputDirectByteBuffers(), ServerFCGIConnection.this.sendStatus200, ServerFCGIConnection.this.flusher, request));
            HttpChannelOverFCGI existing = ServerFCGIConnection.this.channels.putIfAbsent(request, channel);
            if (existing != null) {
                throw new IllegalStateException();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} start on {}", (Object)request, (Object)channel);
            }
        }

        public void onHeader(int request, HttpField field) {
            HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)ServerFCGIConnection.this.channels.get(request));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} header {} on {}", new Object[]{request, field, channel});
            }
            if (channel != null) {
                channel.header(field);
            }
        }

        public boolean onHeaders(int request) {
            HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)ServerFCGIConnection.this.channels.get(request));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} headers on {}", (Object)request, (Object)channel);
            }
            if (channel != null) {
                channel.onRequest();
                channel.dispatch();
            }
            return false;
        }

        public boolean onContent(int request, FCGI.StreamType stream, ByteBuffer buffer) {
            HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)ServerFCGIConnection.this.channels.get(request));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} {} content {} on {}", new Object[]{request, stream, buffer, channel});
            }
            if (channel != null) {
                ByteBuffer copy = ByteBuffer.allocate(buffer.remaining());
                copy.put(buffer).flip();
                channel.onContent(new HttpInput.Content(copy));
            }
            return false;
        }

        public void onEnd(int request) {
            HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)ServerFCGIConnection.this.channels.remove(request));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} end on {}", (Object)request, (Object)channel);
            }
            if (channel != null) {
                channel.onContentComplete();
                channel.onRequestComplete();
            }
        }

        public void onFailure(int request, Throwable failure) {
            HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)ServerFCGIConnection.this.channels.remove(request));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} failure on {}: {}", new Object[]{request, channel, failure});
            }
            if (channel != null) {
                channel.onBadMessage(new BadMessageException(400, null, failure));
            }
        }
    }
}

