/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.server;

import java.nio.ByteBuffer;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.generator.Flusher;
import org.eclipse.jetty.fcgi.parser.ServerParser;
import org.eclipse.jetty.fcgi.server.HttpChannelOverFCGI;
import org.eclipse.jetty.fcgi.server.HttpTransportOverFCGI;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.io.RetainableByteBufferPool;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.util.component.Container;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerFCGIConnection
extends AbstractConnection {
    private static final Logger LOG = LoggerFactory.getLogger(ServerFCGIConnection.class);
    private final Connector connector;
    private final RetainableByteBufferPool networkByteBufferPool;
    private final boolean sendStatus200;
    private final Flusher flusher;
    private final HttpConfiguration configuration;
    private final ServerParser parser;
    private boolean useInputDirectByteBuffers;
    private boolean useOutputDirectByteBuffers;
    private RetainableByteBuffer networkBuffer;
    private HttpChannelOverFCGI channel;

    public ServerFCGIConnection(Connector connector, EndPoint endPoint, HttpConfiguration configuration, boolean sendStatus200) {
        super(endPoint, connector.getExecutor());
        this.connector = connector;
        this.networkByteBufferPool = RetainableByteBufferPool.findOrAdapt((Container)connector, (ByteBufferPool)connector.getByteBufferPool());
        this.flusher = new Flusher(endPoint);
        this.configuration = configuration;
        this.sendStatus200 = sendStatus200;
        this.parser = new ServerParser((ServerParser.Listener)new ServerListener());
    }

    public boolean isUseInputDirectByteBuffers() {
        return this.useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this.useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this.useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this.useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    public void onFillable() {
        this.acquireInputBuffer();
        try {
            int read;
            block7: {
                do {
                    read = this.fillInputBuffer();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Read {} bytes from {} {}", new Object[]{read, this.getEndPoint(), this});
                    }
                    if (read <= 0) break block7;
                } while (!this.parse(this.networkBuffer.getBuffer()));
                return;
            }
            if (read == 0) {
                this.releaseInputBuffer();
                this.fillInterested();
            } else {
                this.releaseInputBuffer();
                this.shutdown();
            }
        }
        catch (Exception x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to fill endpoint", (Throwable)x);
            }
            this.networkBuffer.clear();
            this.releaseInputBuffer();
        }
    }

    void parseAndFill() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("parseAndFill {}", (Object)this);
        }
        while (this.channel != null) {
            if (this.parse(this.networkBuffer.getBuffer())) {
                return;
            }
            if (this.channel == null) {
                return;
            }
            if (this.fillInputBuffer() > 0) continue;
            break;
        }
    }

    private void acquireInputBuffer() {
        if (this.networkBuffer == null) {
            this.networkBuffer = this.networkByteBufferPool.acquire(this.configuration.getResponseHeaderSize(), this.isUseInputDirectByteBuffers());
        }
    }

    private void releaseInputBuffer() {
        boolean released = this.networkBuffer.release();
        if (LOG.isDebugEnabled()) {
            LOG.debug("releaseInputBuffer {} {}", (Object)released, (Object)this);
        }
        if (released) {
            this.networkBuffer = null;
        }
    }

    private int fillInputBuffer() {
        try {
            return this.getEndPoint().fill(this.networkBuffer.getBuffer());
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not fill from {}", (Object)this, (Object)x);
            }
            return -1;
        }
    }

    protected boolean onReadTimeout(Throwable timeout) {
        if (this.channel != null) {
            return this.channel.onIdleTimeout(timeout);
        }
        return true;
    }

    private boolean parse(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            boolean result = this.parser.parse(buffer);
            if (!result) continue;
            return true;
        }
        return false;
    }

    private void shutdown() {
        this.flusher.shutdown();
    }

    void onCompleted(boolean fillMore) {
        this.releaseInputBuffer();
        if (this.getEndPoint().isOpen() && fillMore) {
            this.fillInterested();
        }
    }

    private class ServerListener
    implements ServerParser.Listener {
        private ServerListener() {
        }

        public void onStart(int request, FCGI.Role role, int flags) {
            if (ServerFCGIConnection.this.channel != null) {
                throw new UnsupportedOperationException("FastCGI Multiplexing");
            }
            ServerFCGIConnection.this.channel = new HttpChannelOverFCGI(ServerFCGIConnection.this, ServerFCGIConnection.this.connector, ServerFCGIConnection.this.configuration, ServerFCGIConnection.this.getEndPoint(), new HttpTransportOverFCGI(ServerFCGIConnection.this.connector.getByteBufferPool(), ServerFCGIConnection.this.isUseOutputDirectByteBuffers(), ServerFCGIConnection.this.sendStatus200, ServerFCGIConnection.this.flusher, request));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} start on {}", (Object)request, (Object)ServerFCGIConnection.this.channel);
            }
        }

        public void onHeader(int request, HttpField field) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} header {} on {}", new Object[]{request, field, ServerFCGIConnection.this.channel});
            }
            if (ServerFCGIConnection.this.channel != null) {
                ServerFCGIConnection.this.channel.header(field);
            }
        }

        public boolean onHeaders(int request) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} headers on {}", (Object)request, (Object)ServerFCGIConnection.this.channel);
            }
            if (ServerFCGIConnection.this.channel != null) {
                ServerFCGIConnection.this.channel.onRequest();
                ServerFCGIConnection.this.channel.dispatch();
                return true;
            }
            return false;
        }

        public boolean onContent(int request, FCGI.StreamType stream, ByteBuffer buffer) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} {} content {} on {}", new Object[]{request, stream, buffer, ServerFCGIConnection.this.channel});
            }
            if (ServerFCGIConnection.this.channel != null) {
                ServerFCGIConnection.this.channel.onContent(new FastCGIContent(buffer));
                return true;
            }
            return false;
        }

        public void onEnd(int request) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} end on {}", (Object)request, (Object)ServerFCGIConnection.this.channel);
            }
            if (ServerFCGIConnection.this.channel != null) {
                ServerFCGIConnection.this.channel.onContentComplete();
                ServerFCGIConnection.this.channel.onRequestComplete();
                ServerFCGIConnection.this.channel = null;
            }
        }

        public void onFailure(int request, Throwable failure) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Request {} failure on {}: {}", new Object[]{request, ServerFCGIConnection.this.channel, failure});
            }
            if (ServerFCGIConnection.this.channel != null) {
                ServerFCGIConnection.this.channel.onBadMessage(new BadMessageException(400, null, failure));
            }
            ServerFCGIConnection.this.channel = null;
        }

        private class FastCGIContent
        extends HttpInput.Content {
            public FastCGIContent(ByteBuffer content) {
                super(content);
                ServerFCGIConnection.this.networkBuffer.retain();
            }

            public void succeeded() {
                this.release();
            }

            public void failed(Throwable x) {
                this.release();
            }

            private void release() {
                ServerFCGIConnection.this.networkBuffer.release();
            }
        }
    }
}

