/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.parser.ContentParser;
import org.eclipse.jetty.fcgi.parser.HeaderParser;
import org.eclipse.jetty.fcgi.parser.Parser;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class StreamContentParser
extends ContentParser {
    private static final Logger LOG = Log.getLogger(StreamContentParser.class);
    private final FCGI.StreamType streamType;
    private final Parser.Listener listener;
    private State state = State.LENGTH;
    private int contentLength;

    public StreamContentParser(HeaderParser headerParser, FCGI.StreamType streamType, Parser.Listener listener) {
        super(headerParser);
        this.streamType = streamType;
        this.listener = listener;
    }

    @Override
    public ContentParser.Result parse(ByteBuffer buffer) {
        block4: while (buffer.hasRemaining()) {
            switch (this.state) {
                case LENGTH: {
                    this.contentLength = this.getContentLength();
                    this.state = State.CONTENT;
                    continue block4;
                }
                case CONTENT: {
                    int length = Math.min(this.contentLength, buffer.remaining());
                    int limit = buffer.limit();
                    buffer.limit(buffer.position() + length);
                    ByteBuffer slice = buffer.slice();
                    buffer.position(buffer.limit());
                    buffer.limit(limit);
                    this.contentLength -= length;
                    if (this.onContent(slice)) {
                        return ContentParser.Result.ASYNC;
                    }
                    if (this.contentLength > 0) continue block4;
                    this.state = State.LENGTH;
                    return ContentParser.Result.COMPLETE;
                }
            }
            throw new IllegalStateException();
        }
        return ContentParser.Result.PENDING;
    }

    @Override
    public void noContent() {
        block2: {
            try {
                this.listener.onEnd(this.getRequest());
            }
            catch (Throwable x) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug("Exception while invoking listener " + this.listener, x);
            }
        }
    }

    protected boolean onContent(ByteBuffer buffer) {
        try {
            return this.listener.onContent(this.getRequest(), this.streamType, buffer);
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Exception while invoking listener " + this.listener, x);
            }
            return false;
        }
    }

    protected void end(int request) {
    }

    private static enum State {
        LENGTH,
        CONTENT;

    }
}

