/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.parser.ContentParser;
import org.eclipse.jetty.fcgi.parser.HeaderParser;
import org.eclipse.jetty.http.HttpField;

public abstract class Parser {
    protected final HeaderParser headerParser = new HeaderParser();
    private State state = State.HEADER;
    private int padding;

    public void parse(ByteBuffer buffer) {
        block5: while (true) {
            switch (this.state) {
                case HEADER: {
                    if (!this.headerParser.parse(buffer)) {
                        return;
                    }
                    this.state = State.CONTENT;
                    continue block5;
                }
                case CONTENT: {
                    ContentParser contentParser = this.findContentParser(this.headerParser.getFrameType());
                    if (this.headerParser.getContentLength() == 0) {
                        contentParser.noContent();
                    } else if (!contentParser.parse(buffer)) {
                        return;
                    }
                    this.padding = this.headerParser.getPaddingLength();
                    this.state = State.PADDING;
                    continue block5;
                }
                case PADDING: {
                    if (buffer.remaining() >= this.padding) {
                        buffer.position(buffer.position() + this.padding);
                        this.reset();
                        continue block5;
                    }
                    this.padding -= buffer.remaining();
                    buffer.position(buffer.limit());
                    return;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    protected abstract ContentParser findContentParser(FCGI.FrameType var1);

    private void reset() {
        this.headerParser.reset();
        this.state = State.HEADER;
        this.padding = 0;
    }

    private static enum State {
        HEADER,
        CONTENT,
        PADDING;

    }

    public static interface Listener {
        public void onHeader(int var1, HttpField var2);

        public void onHeaders(int var1);

        public void onContent(int var1, FCGI.StreamType var2, ByteBuffer var3);

        public void onEnd(int var1);

        public static class Adapter
        implements Listener {
            @Override
            public void onHeader(int request, HttpField field) {
            }

            @Override
            public void onHeaders(int request) {
            }

            @Override
            public void onContent(int request, FCGI.StreamType stream, ByteBuffer buffer) {
            }

            @Override
            public void onEnd(int request) {
            }
        }
    }
}

