/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.http;

import java.io.EOFException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.HttpConnection;
import org.eclipse.jetty.client.HttpDestination;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.PoolingHttpDestination;
import org.eclipse.jetty.client.api.Connection;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.client.api.Response;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.client.http.HttpChannelOverFCGI;
import org.eclipse.jetty.fcgi.generator.Flusher;
import org.eclipse.jetty.fcgi.parser.ClientParser;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class HttpConnectionOverFCGI
extends AbstractConnection
implements Connection {
    private static final Logger LOG = Log.getLogger(HttpConnectionOverFCGI.class);
    private final LinkedList<Integer> requests = new LinkedList();
    private final Map<Integer, HttpChannelOverFCGI> channels = new ConcurrentHashMap<Integer, HttpChannelOverFCGI>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Flusher flusher;
    private final HttpDestination destination;
    private final Delegate delegate;
    private final ClientParser parser;

    public HttpConnectionOverFCGI(EndPoint endPoint, HttpDestination destination) {
        super(endPoint, destination.getHttpClient().getExecutor(), destination.getHttpClient().isDispatchIO());
        this.flusher = new Flusher(endPoint);
        this.destination = destination;
        this.delegate = new Delegate(destination);
        this.parser = new ClientParser(new ResponseListener());
        this.requests.addLast(0);
    }

    public HttpDestination getHttpDestination() {
        return this.destination;
    }

    public void send(Request request, Response.CompleteListener listener) {
        this.delegate.send(request, listener);
    }

    protected void send(HttpExchange exchange) {
        this.delegate.send(exchange);
    }

    public void onOpen() {
        super.onOpen();
        this.fillInterested();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFillable() {
        EndPoint endPoint = this.getEndPoint();
        HttpClient client = this.destination.getHttpClient();
        ByteBufferPool bufferPool = client.getByteBufferPool();
        ByteBuffer buffer = bufferPool.acquire(client.getResponseBufferSize(), true);
        try {
            int read;
            while (true) {
                read = endPoint.fill(buffer);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Read {} bytes from {}", new Object[]{read, endPoint});
                }
                if (read <= 0) break;
                this.parse(buffer);
            }
            if (read == 0) {
                this.fillInterested();
            } else {
                this.shutdown();
            }
        }
        catch (Exception x) {
            LOG.debug((Throwable)x);
        }
        finally {
            bufferPool.release(buffer);
        }
    }

    private void parse(ByteBuffer buffer) {
        while (buffer.hasRemaining()) {
            this.parser.parse(buffer);
        }
    }

    private void shutdown() {
        this.close();
        for (HttpChannelOverFCGI channel : this.channels.values()) {
            channel.abort(new EOFException());
        }
    }

    protected boolean onReadTimeout() {
        for (HttpChannelOverFCGI channel : this.channels.values()) {
            channel.abort(new TimeoutException());
        }
        this.close();
        return false;
    }

    public void release() {
        if (this.destination instanceof PoolingHttpDestination) {
            PoolingHttpDestination fcgiDestination = (PoolingHttpDestination)this.destination;
            fcgiDestination.release((Connection)this);
        }
    }

    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.getHttpDestination().close((Connection)this);
            this.getEndPoint().shutdownOutput();
            LOG.debug("{} oshut", new Object[]{this});
            this.getEndPoint().close();
            LOG.debug("{} closed", new Object[]{this});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int acquireRequest() {
        LinkedList<Integer> linkedList = this.requests;
        synchronized (linkedList) {
            int last = this.requests.getLast();
            int request = last + 1;
            this.requests.addLast(request);
            return request;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseRequest(int request) {
        LinkedList<Integer> linkedList = this.requests;
        synchronized (linkedList) {
            this.requests.removeFirstOccurrence(request);
        }
    }

    public String toString() {
        return String.format("%s@%h(l:%s <-> r:%s)", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), this, this.getEndPoint().getLocalAddress(), this.getEndPoint().getRemoteAddress()});
    }

    private class ResponseListener
    implements ClientParser.Listener {
        private ResponseListener() {
        }

        @Override
        public void onBegin(int request, int code, String reason) {
            HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)HttpConnectionOverFCGI.this.channels.get(request));
            if (channel != null) {
                channel.responseBegin(code, reason);
            } else {
                this.noChannel(request);
            }
        }

        @Override
        public void onHeader(int request, HttpField field) {
            HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)HttpConnectionOverFCGI.this.channels.get(request));
            if (channel != null) {
                channel.responseHeader(field);
            } else {
                this.noChannel(request);
            }
        }

        @Override
        public void onHeaders(int request) {
            HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)HttpConnectionOverFCGI.this.channels.get(request));
            if (channel != null) {
                channel.responseHeaders();
            } else {
                this.noChannel(request);
            }
        }

        @Override
        public void onContent(int request, FCGI.StreamType stream, ByteBuffer buffer) {
            switch (stream) {
                case STD_OUT: {
                    HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)HttpConnectionOverFCGI.this.channels.get(request));
                    if (channel != null) {
                        channel.content(buffer);
                        break;
                    }
                    this.noChannel(request);
                    break;
                }
                case STD_ERR: {
                    LOG.info(BufferUtil.toUTF8String((ByteBuffer)buffer), new Object[0]);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        @Override
        public void onEnd(int request) {
            HttpChannelOverFCGI channel = (HttpChannelOverFCGI)((Object)HttpConnectionOverFCGI.this.channels.remove(request));
            if (channel != null) {
                channel.responseSuccess();
                HttpConnectionOverFCGI.this.releaseRequest(request);
            } else {
                this.noChannel(request);
            }
        }

        private void noChannel(int request) {
        }
    }

    private class Delegate
    extends HttpConnection {
        private Delegate(HttpDestination destination) {
            super(destination);
        }

        protected void send(HttpExchange exchange) {
            Request request = exchange.getRequest();
            this.normalizeRequest(request);
            int id = HttpConnectionOverFCGI.this.acquireRequest();
            HttpChannelOverFCGI channel = new HttpChannelOverFCGI(HttpConnectionOverFCGI.this, HttpConnectionOverFCGI.this.flusher, id, request.getIdleTimeout());
            HttpConnectionOverFCGI.this.channels.put(id, channel);
            channel.associate(exchange);
            channel.send();
        }

        public void close() {
            HttpConnectionOverFCGI.this.close();
        }

        public String toString() {
            return HttpConnectionOverFCGI.this.toString();
        }
    }
}

