/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.parser;

import java.nio.ByteBuffer;
import java.util.EnumMap;
import org.eclipse.jetty.fcgi.FCGI;
import org.eclipse.jetty.fcgi.parser.ContentParser;
import org.eclipse.jetty.fcgi.parser.EndRequestContentParser;
import org.eclipse.jetty.fcgi.parser.Parser;
import org.eclipse.jetty.fcgi.parser.ResponseContentParser;
import org.eclipse.jetty.fcgi.parser.StreamContentParser;
import org.eclipse.jetty.http.HttpField;

public class ClientParser
extends Parser {
    private final EnumMap<FCGI.FrameType, ContentParser> contentParsers = new EnumMap(FCGI.FrameType.class);

    public ClientParser(Listener listener) {
        ResponseContentParser stdOutParser = new ResponseContentParser(this.headerParser, listener);
        this.contentParsers.put(FCGI.FrameType.STDOUT, stdOutParser);
        StreamContentParser stdErrParser = new StreamContentParser(this.headerParser, FCGI.StreamType.STD_ERR, listener);
        this.contentParsers.put(FCGI.FrameType.STDERR, stdErrParser);
        this.contentParsers.put(FCGI.FrameType.END_REQUEST, new EndRequestContentParser(this.headerParser, new EndRequestListener(listener, stdOutParser, stdErrParser)));
    }

    @Override
    protected ContentParser findContentParser(FCGI.FrameType frameType) {
        return this.contentParsers.get((Object)frameType);
    }

    private class EndRequestListener
    implements Listener {
        private final Listener listener;
        private final StreamContentParser[] streamParsers;

        private EndRequestListener(Listener listener, StreamContentParser ... streamParsers) {
            this.listener = listener;
            this.streamParsers = streamParsers;
        }

        @Override
        public void onBegin(int request, int code, String reason) {
            this.listener.onBegin(request, code, reason);
        }

        @Override
        public void onHeader(int request, HttpField field) {
            this.listener.onHeader(request, field);
        }

        @Override
        public void onHeaders(int request) {
            this.listener.onHeaders(request);
        }

        @Override
        public boolean onContent(int request, FCGI.StreamType stream, ByteBuffer buffer) {
            return this.listener.onContent(request, stream, buffer);
        }

        @Override
        public void onEnd(int request) {
            this.listener.onEnd(request);
            for (StreamContentParser streamParser : this.streamParsers) {
                streamParser.end(request);
            }
        }

        @Override
        public void onFailure(int request, Throwable failure) {
            this.listener.onFailure(request, failure);
            for (StreamContentParser streamParser : this.streamParsers) {
                streamParser.end(request);
            }
        }
    }

    public static interface Listener
    extends Parser.Listener {
        public void onBegin(int var1, int var2, String var3);

        public static class Adapter
        extends Parser.Listener.Adapter
        implements Listener {
            @Override
            public void onBegin(int request, int code, String reason) {
            }
        }
    }
}

