/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.embedded;

import java.io.IOException;
import java.util.EnumSet;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.ServletResponse;
import org.eclipse.jetty.embedded.DumpServlet;
import org.eclipse.jetty.embedded.HelloServlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ListenerHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;

public class OneServletContext {
    public static void main(String[] args) throws Exception {
        Server server = new Server(8080);
        ServletContextHandler context = new ServletContextHandler(1);
        context.setContextPath("/");
        context.setResourceBase(System.getProperty("java.io.tmpdir"));
        server.setHandler((Handler)context);
        context.addServlet(context.addServlet(DumpServlet.class, "/dump/*"), "*.dump");
        context.addServlet(HelloServlet.class, "/hello/*");
        context.addServlet(DefaultServlet.class, "/");
        context.addFilter(TestFilter.class, "/*", EnumSet.of(DispatcherType.REQUEST));
        context.addFilter(TestFilter.class, "/test", EnumSet.of(DispatcherType.REQUEST, DispatcherType.ASYNC));
        context.addFilter(TestFilter.class, "*.test", EnumSet.of(DispatcherType.REQUEST, DispatcherType.INCLUDE, DispatcherType.FORWARD));
        context.getServletHandler().addListener(new ListenerHolder(InitListener.class));
        context.getServletHandler().addListener(new ListenerHolder(RequestListener.class));
        server.start();
        server.dumpStdErr();
        server.join();
    }

    public static class RequestListener
    implements ServletRequestListener {
        public void requestDestroyed(ServletRequestEvent sre) {
        }

        public void requestInitialized(ServletRequestEvent sre) {
        }
    }

    public static class InitListener
    implements ServletContextListener {
        public void contextInitialized(ServletContextEvent sce) {
        }

        public void contextDestroyed(ServletContextEvent sce) {
        }
    }

    public static class TestFilter
    implements Filter {
        public void init(FilterConfig filterConfig) throws ServletException {
        }

        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            chain.doFilter(request, response);
        }

        public void destroy() {
        }
    }
}

